/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.qute.Expression;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.Variant;
import io.quarkus.qute.api.ResourcePath;
import io.quarkus.qute.runtime.EngineProducer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class TemplateProducer {
    private static final Logger LOGGER = Logger.getLogger(TemplateProducer.class);
    @Inject
    EngineProducer engineProducer;

    @Produces
    Template getDefaultTemplate(InjectionPoint injectionPoint) {
        String name = null;
        if (injectionPoint.getMember() instanceof Field) {
            name = injectionPoint.getMember().getName();
        } else {
            AnnotatedParameter parameter = (AnnotatedParameter)injectionPoint.getAnnotated();
            if (parameter.getJavaParameter().isNamePresent()) {
                name = parameter.getJavaParameter().getName();
            } else {
                name = injectionPoint.getMember().getName();
                LOGGER.warnf("Parameter name not present - using the method name as the template name instead %s", (Object)name);
            }
        }
        return new InjectableTemplate(name, this.engineProducer.getSuffixes());
    }

    @Produces
    @ResourcePath(value="ignored")
    Template getTemplate(InjectionPoint injectionPoint) {
        ResourcePath path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ResourcePath.class)) continue;
            path = (ResourcePath)qualifier;
            break;
        }
        if (path == null || path.value().isEmpty()) {
            throw new IllegalStateException("No template reource path specified");
        }
        return new InjectableTemplate(path.value(), this.engineProducer.getSuffixes());
    }

    class InjectableTemplate
    implements Template {
        private final Supplier<Template> template;

        public InjectableTemplate(final String path, final Iterable<String> suffixes) {
            this.template = new Supplier<Template>(){

                @Override
                public Template get() {
                    Template template = TemplateProducer.this.engineProducer.getEngine().getTemplate(path);
                    if (template == null) {
                        for (String suffix : suffixes) {
                            template = TemplateProducer.this.engineProducer.getEngine().getTemplate(path + "." + suffix);
                            if (template == null) continue;
                            break;
                        }
                        if (template == null) {
                            throw new IllegalStateException("No template found for path: " + path);
                        }
                    }
                    return template;
                }
            };
        }

        public TemplateInstance instance() {
            return this.template.get().instance();
        }

        public Set<Expression> getExpressions() {
            return this.template.get().getExpressions();
        }

        public String getGeneratedId() {
            return this.template.get().getGeneratedId();
        }

        public Optional<Variant> getVariant() {
            return this.template.get().getVariant();
        }
    }
}

