/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.arc.impl.LazyValue;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Location;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateInstanceBase;
import io.quarkus.qute.Variant;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.QuteRecorder;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Singleton
public class TemplateProducer {
    private static final Logger LOGGER = Logger.getLogger(TemplateProducer.class);
    private final Engine engine;
    private final Map<String, TemplateVariants> templateVariants;

    TemplateProducer(Engine engine, QuteRecorder.QuteContext context, ContentTypes contentTypes) {
        this.engine = engine;
        HashMap<String, TemplateVariants> templateVariants = new HashMap<String, TemplateVariants>();
        for (Map.Entry<String, List<String>> entry : context.getVariants().entrySet()) {
            TemplateVariants var = new TemplateVariants(TemplateProducer.initVariants(entry.getKey(), entry.getValue(), contentTypes), entry.getKey());
            templateVariants.put(entry.getKey(), var);
        }
        this.templateVariants = Collections.unmodifiableMap(templateVariants);
        LOGGER.debugf("Initializing Qute variant templates: %s", templateVariants);
    }

    @Produces
    Template getDefaultTemplate(InjectionPoint injectionPoint) {
        String name = null;
        if (injectionPoint.getMember() instanceof Field) {
            name = injectionPoint.getMember().getName();
        } else {
            AnnotatedParameter parameter = (AnnotatedParameter)injectionPoint.getAnnotated();
            if (parameter.getJavaParameter().isNamePresent()) {
                name = parameter.getJavaParameter().getName();
            } else {
                name = injectionPoint.getMember().getName();
                LOGGER.warnf("Parameter name not present - using the method name as the template name instead %s", (Object)name);
            }
        }
        return new InjectableTemplate(name, this.templateVariants, this.engine);
    }

    @Produces
    @Location(value="ignored")
    Template getTemplate(InjectionPoint injectionPoint) {
        String path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(Location.class)) continue;
            path = ((Location)qualifier).value();
            break;
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalStateException("No template location specified");
        }
        return new InjectableTemplate(path, this.templateVariants, this.engine);
    }

    public Template getInjectableTemplate(String path) {
        return new InjectableTemplate(path, this.templateVariants, this.engine);
    }

    private static Map<Variant, String> initVariants(String base, List<String> availableVariants, ContentTypes contentTypes) {
        LinkedHashMap<Variant, String> map = new LinkedHashMap<Variant, String>();
        for (String path : availableVariants) {
            if (base.equals(path)) continue;
            map.put(new Variant(null, contentTypes.getContentType(path), null), path);
        }
        return map;
    }

    static class TemplateVariants {
        public final Map<Variant, String> variantToTemplate;
        public final String defaultTemplate;

        public TemplateVariants(Map<Variant, String> variants, String defaultTemplate) {
            this.variantToTemplate = variants;
            this.defaultTemplate = defaultTemplate;
        }

        String getId(String contentType) {
            for (Map.Entry<Variant, String> entry : this.variantToTemplate.entrySet()) {
                if (!entry.getKey().getContentType().equals(contentType)) continue;
                return entry.getValue();
            }
            return null;
        }

        public String toString() {
            return "TemplateVariants [default=" + this.defaultTemplate + ", variants=" + this.variantToTemplate + "]";
        }
    }

    static class InjectableTemplate
    implements Template {
        private final String path;
        private final TemplateVariants variants;
        private final Engine engine;
        private final LazyValue<Template> unambiguousTemplate;

        public InjectableTemplate(final String path, Map<String, TemplateVariants> templateVariants, final Engine engine) {
            this.path = path;
            this.variants = templateVariants.get(path);
            this.engine = engine;
            this.unambiguousTemplate = this.variants == null || this.variants.variantToTemplate.size() == 1 ? new LazyValue((Supplier)new Supplier<Template>(){

                @Override
                public Template get() {
                    String id = variants != null ? variants.defaultTemplate : path;
                    return engine.getTemplate(id);
                }
            }) : null;
        }

        public TemplateInstance instance() {
            return new InjectableTemplateInstanceImpl();
        }

        public List<Expression> getExpressions() {
            if (this.unambiguousTemplate != null) {
                return ((Template)this.unambiguousTemplate.get()).getExpressions();
            }
            throw this.ambiguousTemplates("getExpressions()");
        }

        public Expression findExpression(Predicate<Expression> predicate) {
            if (this.unambiguousTemplate != null) {
                return ((Template)this.unambiguousTemplate.get()).findExpression(predicate);
            }
            throw this.ambiguousTemplates("findExpression()");
        }

        public List<ParameterDeclaration> getParameterDeclarations() {
            if (this.unambiguousTemplate != null) {
                return ((Template)this.unambiguousTemplate.get()).getParameterDeclarations();
            }
            throw this.ambiguousTemplates("getParameterDeclarations()");
        }

        public String getGeneratedId() {
            if (this.unambiguousTemplate != null) {
                return ((Template)this.unambiguousTemplate.get()).getGeneratedId();
            }
            throw this.ambiguousTemplates("getGeneratedId()");
        }

        public Optional<Variant> getVariant() {
            if (this.unambiguousTemplate != null) {
                return ((Template)this.unambiguousTemplate.get()).getVariant();
            }
            throw this.ambiguousTemplates("getVariant()");
        }

        public String getId() {
            if (this.unambiguousTemplate != null) {
                return ((Template)this.unambiguousTemplate.get()).getId();
            }
            throw this.ambiguousTemplates("getId()");
        }

        public Template.Fragment getFragment(String identifier) {
            if (this.unambiguousTemplate != null) {
                return ((Template)this.unambiguousTemplate.get()).getFragment(identifier);
            }
            throw this.ambiguousTemplates("getFragment()");
        }

        private UnsupportedOperationException ambiguousTemplates(String method) {
            return new UnsupportedOperationException("Ambiguous injected templates do not support " + method);
        }

        public String toString() {
            return "Injectable template [path=" + this.path + "]";
        }

        class InjectableTemplateInstanceImpl
        extends TemplateInstanceBase {
            InjectableTemplateInstanceImpl() {
                if (InjectableTemplate.this.variants != null) {
                    this.setAttribute("variants", List.copyOf(InjectableTemplate.this.variants.variantToTemplate.keySet()));
                }
            }

            public String render() {
                return this.templateInstance().render();
            }

            public CompletionStage<String> renderAsync() {
                return this.templateInstance().renderAsync();
            }

            public Multi<String> createMulti() {
                return this.templateInstance().createMulti();
            }

            public Uni<String> createUni() {
                return this.templateInstance().createUni();
            }

            public CompletionStage<Void> consume(Consumer<String> consumer) {
                return this.templateInstance().consume(consumer);
            }

            protected Engine engine() {
                return InjectableTemplate.this.engine;
            }

            public Template getTemplate() {
                return this.template();
            }

            private TemplateInstance templateInstance() {
                TemplateInstance instance = this.template().instance();
                if (this.dataMap != null) {
                    this.dataMap.forEach((arg_0, arg_1) -> ((TemplateInstance)instance).data(arg_0, arg_1));
                } else if (this.data != null) {
                    instance.data(this.data);
                }
                if (!this.attributes.isEmpty()) {
                    this.attributes.forEach((arg_0, arg_1) -> ((TemplateInstance)instance).setAttribute(arg_0, arg_1));
                }
                if (this.renderedActions != null) {
                    this.renderedActions.forEach(arg_0 -> ((TemplateInstance)instance).onRendered(arg_0));
                }
                return instance;
            }

            private Template template() {
                String id;
                if (InjectableTemplate.this.unambiguousTemplate != null) {
                    return (Template)InjectableTemplate.this.unambiguousTemplate.get();
                }
                Variant selected = (Variant)this.getAttribute("selectedVariant");
                if (selected != null) {
                    id = InjectableTemplate.this.variants.getId(selected.getContentType());
                    if (id == null) {
                        id = InjectableTemplate.this.variants.defaultTemplate;
                    }
                } else {
                    id = InjectableTemplate.this.path;
                }
                return InjectableTemplate.this.engine.getTemplate(id);
            }
        }
    }
}

