/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;

public final class RouteHandlers {
    static final String CONTENT_TYPE = "content-type";

    private RouteHandlers() {
    }

    public static void setContentType(final RoutingContext context, final String defaultContentType) {
        final HttpServerResponse response = context.response();
        context.addHeadersEndHandler((Handler)new Handler<Void>(){

            public void handle(Void aVoid) {
                if (response.headers().get(RouteHandlers.CONTENT_TYPE) == null) {
                    String acceptableContentType = context.getAcceptableContentType();
                    if (acceptableContentType != null) {
                        response.putHeader(RouteHandlers.CONTENT_TYPE, acceptableContentType);
                    } else if (defaultContentType != null) {
                        response.putHeader(RouteHandlers.CONTENT_TYPE, defaultContentType);
                    }
                }
            }
        });
    }
}

