/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.redis.client.RedisHostsProvider;
import io.quarkus.redis.client.RedisOptionsCustomizer;
import io.quarkus.redis.runtime.client.config.NetConfig;
import io.quarkus.redis.runtime.client.config.RedisClientConfig;
import io.quarkus.redis.runtime.client.config.TlsConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.smallrye.common.annotation.Identifier;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.redis.client.Redis;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptions;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VertxRedisClientFactory {
    public static final String DEFAULT_CLIENT = "<default>";

    private VertxRedisClientFactory() {
    }

    public static Redis create(String name, Vertx vertx, RedisClientConfig config) {
        RedisOptions options = new RedisOptions();
        ArrayList<URI> hosts = new ArrayList<URI>();
        if (config.hosts.isPresent()) {
            hosts.addAll((Collection)config.hosts.get());
            for (URI uri : config.hosts.get()) {
                options.addConnectionString(uri.toString().trim());
            }
        } else if (config.hostsProviderName.isPresent()) {
            RedisHostsProvider hostsProvider = VertxRedisClientFactory.findProvider(config.hostsProviderName.get());
            hosts.addAll(hostsProvider.getHosts());
            for (URI uri : hostsProvider.getHosts()) {
                options.addConnectionString(uri.toString());
            }
        } else {
            throw new ConfigurationException("Redis host not configured - you must either configure 'quarkus.redis.hosts` or 'quarkus.redis.host-provider-name' and have a bean providing the hosts programmatically.");
        }
        if (RedisClientType.STANDALONE == config.clientType && hosts.size() > 1) {
            throw new ConfigurationException("Multiple Redis hosts supplied for non-clustered configuration");
        }
        config.masterName.ifPresent(arg_0 -> ((RedisOptions)options).setMasterName(arg_0));
        options.setMaxNestedArrays(config.maxNestedArrays);
        options.setMaxPoolSize(config.maxPoolSize);
        options.setMaxPoolWaiting(config.maxPoolWaiting);
        options.setMaxWaitingHandlers(config.maxWaitingHandlers);
        options.setProtocolNegotiation(config.protocolNegotiation);
        options.setPassword((String)config.password.orElse(null));
        config.poolCleanerInterval.ifPresent(d -> options.setPoolCleanerInterval((int)d.toMillis()));
        options.setPoolRecycleTimeout((int)config.poolRecycleTimeout.toMillis());
        config.role.ifPresent(arg_0 -> ((RedisOptions)options).setRole(arg_0));
        options.setType(config.clientType);
        config.replicas.ifPresent(arg_0 -> ((RedisOptions)options).setUseReplicas(arg_0));
        options.setNetClientOptions(VertxRedisClientFactory.toNetClientOptions(config));
        VertxRedisClientFactory.customize(name, options);
        return Redis.createClient((Vertx)vertx, (RedisOptions)options);
    }

    private static void customize(String name, RedisOptions options) {
        if (Arc.container() != null) {
            List customizers = Arc.container().listAll(RedisOptionsCustomizer.class, new Annotation[0]);
            for (InstanceHandle customizer : customizers) {
                ((RedisOptionsCustomizer)customizer.get()).customize(name, options);
            }
        }
    }

    private static NetClientOptions toNetClientOptions(RedisClientConfig config) {
        NetConfig tcp = config.tcp;
        TlsConfig tls = config.tls;
        NetClientOptions net = new NetClientOptions();
        tcp.alpn.ifPresent(arg_0 -> ((NetClientOptions)net).setUseAlpn(arg_0));
        tcp.applicationLayerProtocols.ifPresent(arg_0 -> ((NetClientOptions)net).setApplicationLayerProtocols(arg_0));
        tcp.connectionTimeout.ifPresent(d -> net.setConnectTimeout((int)d.toMillis()));
        tls.hostnameVerificationAlgorithm.ifPresent(arg_0 -> ((NetClientOptions)net).setHostnameVerificationAlgorithm(arg_0));
        tcp.idleTimeout.ifPresent(d -> net.setIdleTimeout((int)d.toSeconds()));
        tcp.keepAlive.ifPresent(b -> net.setTcpKeepAlive(true));
        tcp.noDelay.ifPresent(b -> net.setTcpNoDelay(true));
        net.setSsl(tls.enabled).setTrustAll(tls.trustAll);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)net, (PemTrustCertConfiguration)tls.trustCertificatePem);
        SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)net, (JksConfiguration)tls.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)net, (PfxConfiguration)tls.trustCertificatePfx);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)net, (PemKeyCertConfiguration)tls.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)net, (JksConfiguration)tls.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)net, (PfxConfiguration)tls.keyCertificatePfx);
        net.setReconnectAttempts(config.reconnectAttempts);
        net.setReconnectInterval(config.reconnectInterval.toMillis());
        tcp.localAddress.ifPresent(arg_0 -> ((NetClientOptions)net).setLocalAddress(arg_0));
        tcp.nonProxyHosts.ifPresent(arg_0 -> ((NetClientOptions)net).setNonProxyHosts(arg_0));
        tcp.proxyOptions.ifPresent(s -> {
            ProxyOptions po = new ProxyOptions();
            po.setHost(s.host);
            po.setType(s.type);
            po.setPort(s.port);
            s.username.ifPresent(arg_0 -> ((ProxyOptions)po).setUsername(arg_0));
            s.password.ifPresent(arg_0 -> ((ProxyOptions)po).setPassword(arg_0));
            net.setProxyOptions(po);
        });
        tcp.readIdleTimeout.ifPresent(d -> net.setReadIdleTimeout((int)d.toSeconds()));
        tcp.reconnectAttempts.ifPresent(arg_0 -> ((NetClientOptions)net).setReconnectAttempts(arg_0));
        tcp.reconnectInterval.ifPresent(v -> net.setReconnectInterval(v.toMillis()));
        tcp.reuseAddress.ifPresent(arg_0 -> ((NetClientOptions)net).setReuseAddress(arg_0));
        tcp.reusePort.ifPresent(arg_0 -> ((NetClientOptions)net).setReusePort(arg_0));
        tcp.receiveBufferSize.ifPresent(arg_0 -> ((NetClientOptions)net).setReceiveBufferSize(arg_0));
        tcp.sendBufferSize.ifPresent(arg_0 -> ((NetClientOptions)net).setSendBufferSize(arg_0));
        tcp.soLinger.ifPresent(d -> net.setSoLinger((int)d.toMillis()));
        tcp.secureTransportProtocols.ifPresent(arg_0 -> ((NetClientOptions)net).setEnabledSecureTransportProtocols(arg_0));
        tcp.trafficClass.ifPresent(arg_0 -> ((NetClientOptions)net).setTrafficClass(arg_0));
        tcp.noDelay.ifPresent(arg_0 -> ((NetClientOptions)net).setTcpNoDelay(arg_0));
        tcp.cork.ifPresent(arg_0 -> ((NetClientOptions)net).setTcpCork(arg_0));
        tcp.keepAlive.ifPresent(arg_0 -> ((NetClientOptions)net).setTcpKeepAlive(arg_0));
        tcp.fastOpen.ifPresent(arg_0 -> ((NetClientOptions)net).setTcpFastOpen(arg_0));
        tcp.quickAck.ifPresent(arg_0 -> ((NetClientOptions)net).setTcpQuickAck(arg_0));
        tcp.writeIdleTimeout.ifPresent(d -> net.setWriteIdleTimeout((int)d.toSeconds()));
        tls.hostnameVerificationAlgorithm.ifPresent(arg_0 -> ((NetClientOptions)net).setHostnameVerificationAlgorithm(arg_0));
        return net;
    }

    public static RedisHostsProvider findProvider(String name) {
        InjectableInstance providers;
        ArcContainer container = Arc.container();
        if (name != null) {
            providers = container.select(RedisHostsProvider.class, new Annotation[]{Identifier.Literal.of((String)name)});
            if (providers.isUnsatisfied()) {
                throw new ConfigurationException("Unable to find redis host provider identified with " + name);
            }
        } else {
            providers = container.select(RedisHostsProvider.class, new Annotation[0]);
            if (providers.isUnsatisfied()) {
                throw new ConfigurationException("Unable to find redis host provider");
            }
        }
        return (RedisHostsProvider)providers.get();
    }
}

