/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.util.List;
import java.util.Map;

public class AbstractCountMinCommands<K, V>
extends AbstractRedisCommands {
    AbstractCountMinCommands(RedisCommandExecutor redis, Class<K> k, Class<V> v) {
        super(redis, new Marshaller(k, v));
    }

    Uni<Response> _cmsIncrBy(K key, V value, long increment) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(value, (String)"value");
        RedisCommand cmd = RedisCommand.of(Command.CMS_INCRBY).put(this.marshaller.encode(key)).put(this.marshaller.encode(value)).put(increment);
        return this.execute(cmd);
    }

    Uni<Response> _cmsIncrBy(K key, Map<V, Long> couples) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(couples, (String)"couples");
        if (couples.isEmpty()) {
            throw new IllegalArgumentException("`couples` must not be empty");
        }
        RedisCommand cmd = RedisCommand.of(Command.CMS_INCRBY).put(this.marshaller.encode(key));
        for (Map.Entry<V, Long> entry : couples.entrySet()) {
            cmd.put(this.marshaller.encode(entry.getKey()));
            cmd.put(entry.getValue());
        }
        return this.execute(cmd);
    }

    Uni<Response> _cmsInitByDim(K key, long width, long depth) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.CMS_INITBYDIM).put(this.marshaller.encode(key)).put(width).put(depth);
        return this.execute(cmd);
    }

    Uni<Response> _cmsInitByProb(K key, double error, double probability) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.CMS_INITBYPROB).put(this.marshaller.encode(key)).put(error).put(probability);
        return this.execute(cmd);
    }

    Uni<Response> _cmsQuery(K key, V item) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(item, (String)"item");
        RedisCommand cmd = RedisCommand.of(Command.CMS_QUERY).put(this.marshaller.encode(key)).put(this.marshaller.encode(item));
        return this.execute(cmd);
    }

    Uni<Response> _cmsQuery(K key, V ... items) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.doesNotContainNull((Object[])items, (String)"items");
        if (items.length == 0) {
            throw new IllegalArgumentException("`items` must not be empty");
        }
        RedisCommand cmd = RedisCommand.of(Command.CMS_QUERY).put(this.marshaller.encode(key));
        for (V item : items) {
            cmd.put(this.marshaller.encode(item));
        }
        return this.execute(cmd);
    }

    Uni<Response> _cmsMerge(K dest, List<K> src, List<Integer> weight) {
        ParameterValidation.nonNull(dest, (String)"dest");
        ParameterValidation.doesNotContainNull(src, (String)"src");
        ParameterValidation.isNotEmpty(src, (String)"src");
        RedisCommand cmd = RedisCommand.of(Command.CMS_MERGE).put(this.marshaller.encode(dest)).put(src.size());
        for (K k : src) {
            cmd.put(this.marshaller.encode(k));
        }
        if (weight != null) {
            cmd.put("WEIGHTS");
            for (Integer w : weight) {
                cmd.put(w);
            }
        }
        return this.execute(cmd);
    }
}

