/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.time.Duration;

public class AbstractGraphCommands<K>
extends AbstractRedisCommands {
    AbstractGraphCommands(RedisCommandExecutor redis, Class<K> k) {
        super(redis, new Marshaller(k));
    }

    Uni<Response> _graphDelete(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.GRAPH_DELETE).put(this.marshaller.encode(key));
        return this.execute(cmd);
    }

    Uni<Response> _graphExplain(K key, String query) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)query, (String)"query");
        RedisCommand cmd = RedisCommand.of(Command.GRAPH_EXPLAIN).put(this.marshaller.encode(key)).put(query);
        return this.execute(cmd);
    }

    Uni<Response> _graphList() {
        RedisCommand cmd = RedisCommand.of(Command.GRAPH_LIST);
        return this.execute(cmd);
    }

    Uni<Response> _graphQuery(K key, String query) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)query, (String)"query");
        RedisCommand cmd = RedisCommand.of(Command.GRAPH_QUERY).put(this.marshaller.encode(key)).put(query);
        return this.execute(cmd);
    }

    Uni<Response> _graphQuery(K key, String query, Duration timeout) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)query, (String)"query");
        ParameterValidation.nonNull((Object)timeout, (String)"timeout");
        RedisCommand cmd = RedisCommand.of(Command.GRAPH_QUERY).put(this.marshaller.encode(key)).put(query).put("TIMEOUT").put(timeout.toMillis());
        return this.execute(cmd);
    }
}

