/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.vertx.mutiny.redis.client.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TransactionHolder {
    private List<Function<Response, Object>> mappers = new ArrayList<Function<Response, Object>>();
    private volatile boolean discarded = false;

    public void enqueue(Function<Response, Object> mapper) {
        this.mappers.add(mapper);
    }

    public List<Object> map(Response response) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < this.mappers.size(); ++i) {
            results.add(this.mappers.get(i).apply(response.get(i)));
        }
        return results;
    }

    public void discard() {
        this.discarded = true;
    }

    public boolean discarded() {
        return this.discarded;
    }
}

