/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.keys.KeyScanCursor;
import io.quarkus.redis.datasource.keys.ReactiveKeyScanCursor;
import java.time.Duration;
import java.util.Set;

public class ScanBlockingCursorImpl<K>
implements KeyScanCursor<K> {
    private final ReactiveKeyScanCursor<K> reactive;
    private final Duration timeout;

    public ScanBlockingCursorImpl(ReactiveKeyScanCursor<K> reactive, Duration timeout) {
        this.timeout = timeout;
        this.reactive = reactive;
    }

    @Override
    public boolean hasNext() {
        return this.reactive.hasNext();
    }

    @Override
    public Set<K> next() {
        return (Set)this.reactive.next().await().atMost(this.timeout);
    }

    @Override
    public long cursorId() {
        return this.reactive.cursorId();
    }

    @Override
    public Iterable<K> toIterable() {
        return this.reactive.toMulti().subscribe().asIterable();
    }
}

