/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.quarkus.restclient.config.RegisteredRestClient;
import io.quarkus.restclient.config.RestClientsConfig;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RestClientNameFallbackConfigSourceInterceptor
extends FallbackConfigSourceInterceptor {
    public RestClientNameFallbackConfigSourceInterceptor(List<RegisteredRestClient> restClients) {
        super(RestClientNameFallbackConfigSourceInterceptor.fallback(restClients));
    }

    private static Function<String, String> fallback(final List<RegisteredRestClient> restClients) {
        Class implementationClass = ConfigMappingLoader.getImplementationClass(RestClientsConfig.class);
        final Set ignoreNames = RestClientNameFallbackConfigSourceInterceptor.configMappingNames(implementationClass).get(RestClientsConfig.class.getName()).get("").stream().filter(s -> s.charAt(0) != '*').map(s -> "quarkus.rest-client." + s).collect(Collectors.toSet());
        return new Function<String, String>(){

            @Override
            public String apply(String name) {
                if (name.startsWith("quarkus.rest-client.")) {
                    if (ignoreNames.contains(name)) {
                        return name;
                    }
                    for (RegisteredRestClient restClient : restClients) {
                        String interfaceName;
                        if (name.length() <= 20 || name.charAt(20) != '\"' || !name.regionMatches(21, interfaceName = restClient.getFullName(), 0, interfaceName.length()) || name.length() <= 21 + interfaceName.length() || name.charAt(21 + interfaceName.length()) != '\"') continue;
                        return "quarkus.rest-client." + restClient.getSimpleName() + name.substring(21 + interfaceName.length() + 1);
                    }
                }
                return name;
            }
        };
    }

    @Deprecated(forRemoval=true)
    private static <T> Map<String, Map<String, Set<String>>> configMappingNames(Class<T> implementationClass) {
        try {
            Method getNames = implementationClass.getDeclaredMethod("getNames", new Class[0]);
            return (Map)getNames.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }
}

