/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.rest.data.panache.deployment.PrivateFields;
import io.quarkus.rest.data.panache.deployment.PrivateMethods;
import io.quarkus.rest.data.panache.deployment.RestDataResourceInfo;
import io.quarkus.rest.data.panache.deployment.methods.MethodMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.MethodPropertiesAccessor;
import io.quarkus.rest.data.panache.deployment.utils.PaginationImplementor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import io.quarkus.rest.data.panache.deployment.utils.SortImplementor;
import javax.ws.rs.core.Response;
import org.jboss.jandex.IndexView;

public final class ListMethodImplementor
extends StandardMethodImplementor {
    public static final String NAME = "list";
    private static final String REL = "list";
    private final PaginationImplementor paginationImplementor = new PaginationImplementor();
    private final SortImplementor sortImplementor = new SortImplementor();

    @Override
    protected void implementInternal(ClassCreator classCreator, IndexView index, MethodPropertiesAccessor propertiesAccessor, RestDataResourceInfo resourceInfo) {
        MethodMetadata methodMetadata = this.getMethodMetadata(resourceInfo);
        MethodCreator methodCreator = classCreator.getMethodCreator(methodMetadata.getName(), Response.class, new Class[0]);
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, propertiesAccessor.getPath(resourceInfo.getType(), methodMetadata));
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceInfo.getEntityInfo().getType(), "list");
        ResultHandle uriInfo = this.getInstanceField(methodCreator, PrivateFields.URI_INFO.getName(), PrivateFields.URI_INFO.getType());
        BranchResult isPagedBranch = this.isPaged(methodCreator);
        this.returnPaged(isPagedBranch.trueBranch(), resourceInfo.getDataAccessImplementor(), uriInfo);
        this.returnNotPaged(isPagedBranch.falseBranch(), resourceInfo.getDataAccessImplementor(), uriInfo);
        methodCreator.close();
    }

    @Override
    protected MethodMetadata getMethodMetadata(RestDataResourceInfo resourceInfo) {
        return new MethodMetadata("list", new String[0]);
    }

    private void returnPaged(BytecodeCreator creator, DataAccessImplementor dataAccessImplementor, ResultHandle uriInfo) {
        ResultHandle sort = this.sortImplementor.getSort(creator, uriInfo);
        ResultHandle page = this.paginationImplementor.getRequestPage(creator, uriInfo);
        ResultHandle pageCount = dataAccessImplementor.pageCount(creator, page);
        ResultHandle links = this.paginationImplementor.getLinks(creator, uriInfo, page, pageCount);
        ResultHandle entities = dataAccessImplementor.findAll(creator, page, sort);
        creator.returnValue(ResponseImplementor.ok(creator, entities, links));
    }

    private void returnNotPaged(BytecodeCreator creator, DataAccessImplementor dataAccessImplementor, ResultHandle uriInfo) {
        ResultHandle sort = this.sortImplementor.getSort(creator, uriInfo);
        creator.returnValue(ResponseImplementor.ok(creator, dataAccessImplementor.listAll(creator, sort)));
    }

    private BranchResult isPaged(MethodCreator creator) {
        MethodDescriptor method = MethodDescriptor.ofMethod((String)creator.getMethodDescriptor().getDeclaringClass(), (String)PrivateMethods.IS_PAGED.getName(), (String)PrivateMethods.IS_PAGED.getType(), (String[])PrivateMethods.IS_PAGED.getParams());
        return creator.ifTrue(creator.invokeVirtualMethod(method, creator.getThis(), new ResultHandle[0]));
    }
}

