/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.properties;

import io.quarkus.rest.data.panache.MethodProperties;
import io.quarkus.rest.data.panache.deployment.methods.MethodMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class MethodPropertiesAccessor {
    private static final DotName OPERATION_PROPERTIES_ANNOTATION = DotName.createSimple((String)MethodProperties.class.getName());
    private final IndexView index;

    public MethodPropertiesAccessor(IndexView index) {
        this.index = index;
    }

    public boolean isExposed(String type, MethodMetadata methodMetadata) {
        AnnotationInstance annotation = this.getAnnotation(DotName.createSimple((String)type), methodMetadata);
        return annotation == null || annotation.value("exposed") == null || annotation.value("exposed").asBoolean();
    }

    public String getPath(String type, MethodMetadata methodMetadata) {
        AnnotationInstance annotation = this.getAnnotation(DotName.createSimple((String)type), methodMetadata);
        if (annotation == null || annotation.value("path") == null) {
            return "";
        }
        return annotation.value("path").asString();
    }

    public String getPath(String type, MethodMetadata methodMetadata, String lastSegment) {
        String path = this.getPath(type, methodMetadata);
        if (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        if (lastSegment.startsWith("/")) {
            lastSegment = lastSegment.substring(1);
        }
        return String.join((CharSequence)"/", path, lastSegment);
    }

    private AnnotationInstance getAnnotation(DotName type, MethodMetadata methodMetadata) {
        ClassInfo classInfo = this.index.getClassByName(type);
        if (classInfo == null) {
            return null;
        }
        Optional<MethodInfo> optionalMethod = this.getMethodInfo(classInfo, methodMetadata);
        if (optionalMethod.isPresent() && optionalMethod.get().hasAnnotation(OPERATION_PROPERTIES_ANNOTATION)) {
            return optionalMethod.get().annotation(OPERATION_PROPERTIES_ANNOTATION);
        }
        if (classInfo.superName() != null) {
            return this.getAnnotation(classInfo.superName(), methodMetadata);
        }
        return null;
    }

    private Optional<MethodInfo> getMethodInfo(ClassInfo classInfo, MethodMetadata methodMetadata) {
        return classInfo.methods().stream().filter(methodInfo -> methodMetadata.getName().equals(methodInfo.name())).filter(methodInfo -> this.doParametersMatch((MethodInfo)methodInfo, methodMetadata.getParameterTypes())).findFirst();
    }

    private boolean doParametersMatch(MethodInfo methodInfo, String ... methodParameterTypes) {
        if (methodInfo.parameters().size() != methodParameterTypes.length) {
            return false;
        }
        List actualParameterTypes = methodInfo.parameters().stream().map(Type::name).map(DotName::toString).collect(Collectors.toList());
        return actualParameterTypes.equals(Arrays.asList(methodParameterTypes));
    }
}

