/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.deployment.processor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.jackson.SecureField;
import io.quarkus.resteasy.reactive.jackson.runtime.mappers.JacksonMapperUtil;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class JacksonSerializerFactory {
    private static final String SUPER_CLASS_NAME = StdSerializer.class.getName();
    private static final String JSON_GEN_CLASS_NAME = JsonGenerator.class.getName();
    private final BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer;
    private final IndexView jandexIndex;
    private final Set<String> generatedClassNames = new HashSet<String>();
    private final Deque<ClassInfo> toBeGenerated = new ArrayDeque<ClassInfo>();

    public JacksonSerializerFactory(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, IndexView jandexIndex) {
        this.generatedClassBuildItemBuildProducer = generatedClassBuildItemBuildProducer;
        this.jandexIndex = jandexIndex;
    }

    public Collection<String> create(Collection<ClassInfo> classInfos) {
        HashSet<String> createdClasses = new HashSet<String>();
        this.toBeGenerated.addAll(classInfos);
        while (!this.toBeGenerated.isEmpty()) {
            this.create(this.toBeGenerated.removeFirst()).ifPresent(createdClasses::add);
        }
        return createdClasses;
    }

    public Optional<String> create(ClassInfo classInfo) {
        String beanClassName = classInfo.name().toString();
        if (this.vetoedClassName(beanClassName) || !this.generatedClassNames.add(beanClassName)) {
            return Optional.empty();
        }
        String generatedClassName = beanClassName + "$quarkusjacksonserializer";
        try (ClassCreator classCreator = new ClassCreator((ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassBuildItemBuildProducer, true), generatedClassName, null, SUPER_CLASS_NAME, new String[0]);){
            this.createConstructor(classCreator, beanClassName);
            boolean valid = this.createSerializeMethod(classInfo, classCreator, beanClassName);
            Optional<String> optional = valid ? Optional.of(generatedClassName) : Optional.empty();
            return optional;
        }
    }

    private void createConstructor(ClassCreator classCreator, String beanClassName) {
        MethodCreator constructor = classCreator.getConstructorCreator(new String[0]);
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)SUPER_CLASS_NAME, (String[])new String[]{"java.lang.Class"}), constructor.getThis(), new ResultHandle[]{constructor.loadClass(beanClassName)});
        constructor.returnVoid();
    }

    private boolean createSerializeMethod(ClassInfo classInfo, ClassCreator classCreator, String beanClassName) {
        MethodCreator serialize = classCreator.getMethodCreator("serialize", "void", new String[]{"java.lang.Object", JSON_GEN_CLASS_NAME, "com.fasterxml.jackson.databind.SerializerProvider"});
        serialize.setModifiers(1);
        serialize.addException(IOException.class);
        boolean valid = this.serializeObject(classInfo, beanClassName, serialize);
        serialize.returnVoid();
        return valid;
    }

    private boolean serializeObject(ClassInfo classInfo, String beanClassName, MethodCreator serialize) {
        HashSet<String> serializedFields = new HashSet<String>();
        ResultHandle valueHandle = serialize.checkCast(serialize.getMethodParam(0), beanClassName);
        ResultHandle jsonGenerator = serialize.getMethodParam(1);
        ResultHandle serializerProvider = serialize.getMethodParam(2);
        MethodDescriptor writeStartObject = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)"writeStartObject", (String)"void", (String[])new String[0]);
        serialize.invokeVirtualMethod(writeStartObject, jsonGenerator, new ResultHandle[0]);
        boolean valid = this.serializeObjectData(classInfo, serialize, valueHandle, jsonGenerator, serializerProvider, serializedFields);
        MethodDescriptor writeEndObject = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)"writeEndObject", (String)"void", (String[])new String[0]);
        serialize.invokeVirtualMethod(writeEndObject, jsonGenerator, new ResultHandle[0]);
        if (serializedFields.isEmpty()) {
            this.throwExceptionForEmptyBean(beanClassName, serialize, jsonGenerator);
        }
        return valid;
    }

    private boolean serializeObjectData(ClassInfo classInfo, MethodCreator serialize, ResultHandle valueHandle, ResultHandle jsonGenerator, ResultHandle serializerProvider, Set<String> serializedFields) {
        return this.serializeFields(classInfo, serialize, valueHandle, jsonGenerator, serializerProvider, serializedFields) && this.serializeMethods(classInfo, serialize, valueHandle, jsonGenerator, serializerProvider, serializedFields);
    }

    private boolean serializeFields(ClassInfo classInfo, MethodCreator serialize, ResultHandle valueHandle, ResultHandle jsonGenerator, ResultHandle serializerProvider, Set<String> serializedFields) {
        for (FieldInfo fieldInfo : this.classFields(classInfo)) {
            String fieldName;
            AnnotationTarget target;
            if (Modifier.isStatic(fieldInfo.flags()) || (target = this.valueReader(classInfo, fieldInfo)) == null || !serializedFields.add(fieldName = fieldInfo.name())) continue;
            if (this.hasUnknownAnnotation((AnnotationTarget)fieldInfo) || fieldInfo != target && this.hasUnknownAnnotation(target)) {
                return false;
            }
            ResultHandle arg = this.toValueReaderHandle(target, (BytecodeCreator)serialize, valueHandle);
            this.writeField(fieldInfo.type(), fieldName, this.writeFieldBranch(serialize, fieldInfo, target), jsonGenerator, serializerProvider, arg);
        }
        return true;
    }

    private boolean serializeMethods(ClassInfo classInfo, MethodCreator serialize, ResultHandle valueHandle, ResultHandle jsonGenerator, ResultHandle serializerProvider, Set<String> serializedFields) {
        for (MethodInfo methodInfo : this.classMethods(classInfo)) {
            String fieldName;
            if (Modifier.isStatic(methodInfo.flags()) || (fieldName = this.fieldNameFromMethod(methodInfo)) == null || !serializedFields.add(fieldName)) continue;
            if (this.hasUnknownAnnotation((AnnotationTarget)methodInfo)) {
                return false;
            }
            ResultHandle arg = serialize.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)methodInfo), valueHandle, new ResultHandle[0]);
            this.writeField(methodInfo.returnType(), fieldName, (BytecodeCreator)serialize, jsonGenerator, serializerProvider, arg);
        }
        return true;
    }

    private void writeField(Type fieldType, String fieldName, BytecodeCreator bytecode, ResultHandle jsonGenerator, ResultHandle serializerProvider, ResultHandle fieldReader) {
        String typeName = fieldType.name().toString();
        String primitiveMethodName = this.writeMethodForPrimitiveFields(typeName);
        if (primitiveMethodName != null) {
            MethodDescriptor primitiveWriter = MethodDescriptor.ofMethod((String)JSON_GEN_CLASS_NAME, (String)primitiveMethodName, (String)"void", (String[])new String[]{"java.lang.String", typeName});
            bytecode.invokeVirtualMethod(primitiveWriter, jsonGenerator, new ResultHandle[]{bytecode.load(fieldName), fieldReader});
            return;
        }
        this.registerTypeToBeGenerated(fieldType, typeName);
        MethodDescriptor writeMethod = MethodDescriptor.ofMethod((Object)JSON_GEN_CLASS_NAME, (String)"writePOJOField", Void.TYPE, (Object[])new Object[]{String.class, Object.class});
        bytecode.invokeVirtualMethod(writeMethod, jsonGenerator, new ResultHandle[]{bytecode.load(fieldName), fieldReader});
    }

    private void registerTypeToBeGenerated(Type fieldType, String typeName) {
        if (!this.isCollectionType(fieldType, typeName)) {
            this.registerTypeToBeGenerated(typeName);
        }
    }

    private boolean isCollectionType(Type fieldType, String typeName) {
        if (fieldType instanceof ArrayType) {
            ArrayType aType = (ArrayType)fieldType;
            this.registerTypeToBeGenerated(aType.constituent());
            return true;
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)fieldType;
            if (pType.arguments().size() == 1 && (typeName.equals("java.util.List") || typeName.equals("java.util.Collection") || typeName.equals("java.util.Set") || typeName.equals("java.lang.Iterable"))) {
                this.registerTypeToBeGenerated((Type)pType.arguments().get(0));
                return true;
            }
            if (pType.arguments().size() == 2 && typeName.equals("java.util.Map")) {
                this.registerTypeToBeGenerated((Type)pType.arguments().get(1));
                this.registerTypeToBeGenerated((Type)pType.arguments().get(1));
                return true;
            }
        }
        return false;
    }

    private void registerTypeToBeGenerated(Type type) {
        this.registerTypeToBeGenerated(type.name().toString());
    }

    private void registerTypeToBeGenerated(String typeName) {
        ClassInfo classInfo;
        if (!this.vetoedClassName(typeName) && (classInfo = this.jandexIndex.getClassByName(typeName)) != null && !classInfo.isEnum()) {
            this.toBeGenerated.add(classInfo);
        }
    }

    private String writeMethodForPrimitiveFields(String typeName) {
        return switch (typeName) {
            case "java.lang.String" -> "writeStringField";
            case "short", "java.lang.Short", "int", "java.lang.Integer", "long", "java.lang.Long", "float", "java.lang.Float", "double", "java.lang.Double" -> "writeNumberField";
            case "boolean", "java.lang.Boolean" -> "writeBooleanField";
            default -> null;
        };
    }

    private boolean hasUnknownAnnotation(AnnotationTarget target) {
        return target.annotations().stream().anyMatch(ann -> ann.name().toString().startsWith("com.fasterxml.jackson."));
    }

    private BytecodeCreator writeFieldBranch(MethodCreator serialize, FieldInfo fieldInfo, AnnotationTarget target) {
        String[] rolesAllowed = this.rolesAllowed(fieldInfo, target);
        if (rolesAllowed != null) {
            ResultHandle rolesArray = serialize.newArray(String.class, rolesAllowed.length);
            for (int i = 0; i < rolesAllowed.length; ++i) {
                serialize.writeArrayValue(rolesArray, serialize.load(i), serialize.load(rolesAllowed[i]));
            }
            MethodDescriptor includeSecureField = MethodDescriptor.ofMethod(JacksonMapperUtil.class, (String)"includeSecureField", Boolean.TYPE, (Class[])new Class[]{String[].class});
            ResultHandle included = serialize.invokeStaticMethod(includeSecureField, new ResultHandle[]{rolesArray});
            return serialize.ifTrue(included).trueBranch();
        }
        return serialize;
    }

    private String[] rolesAllowed(FieldInfo fieldInfo, AnnotationTarget target) {
        AnnotationInstance secureField = fieldInfo.annotation(SecureField.class);
        if (secureField == null && target != fieldInfo) {
            secureField = target.annotation(SecureField.class);
        }
        if (secureField != null) {
            AnnotationValue rolesAllowed = secureField.value("rolesAllowed");
            return rolesAllowed != null ? rolesAllowed.asStringArray() : null;
        }
        return null;
    }

    private Collection<FieldInfo> classFields(ClassInfo classInfo) {
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        this.classFields(classInfo, fields);
        return fields;
    }

    private void classFields(ClassInfo classInfo, Collection<FieldInfo> fields) {
        fields.addAll(classInfo.fields());
        this.onSuperClass(classInfo, superClassInfo -> {
            this.classFields((ClassInfo)superClassInfo, fields);
            return null;
        });
    }

    private Collection<MethodInfo> classMethods(ClassInfo classInfo) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        this.classMethods(classInfo, methods);
        return methods;
    }

    private void classMethods(ClassInfo classInfo, Collection<MethodInfo> methods) {
        methods.addAll(classInfo.methods());
        this.onSuperClass(classInfo, superClassInfo -> {
            this.classMethods((ClassInfo)superClassInfo, methods);
            return null;
        });
    }

    private String fieldNameFromMethod(MethodInfo methodInfo) {
        if (this.isGetterMethod(methodInfo)) {
            String methodName = methodInfo.name();
            return this.isBooleanType(methodInfo.returnType().toString()) ? methodName.substring(2, 3).toLowerCase() + methodName.substring(3) : methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        return null;
    }

    private AnnotationTarget valueReader(ClassInfo classInfo, FieldInfo fieldInfo) {
        MethodInfo getterMethodInfo = this.getterMethodInfo(classInfo, fieldInfo);
        if (getterMethodInfo != null) {
            return getterMethodInfo;
        }
        if (Modifier.isPublic(fieldInfo.flags())) {
            return fieldInfo;
        }
        return null;
    }

    private ResultHandle toValueReaderHandle(Object member, BytecodeCreator serialize, ResultHandle valueHandle) {
        if (member instanceof MethodInfo) {
            MethodInfo m = (MethodInfo)member;
            return serialize.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)m), valueHandle, new ResultHandle[0]);
        }
        if (member instanceof FieldInfo) {
            FieldInfo f = (FieldInfo)member;
            return serialize.readInstanceField(FieldDescriptor.of((FieldInfo)f), valueHandle);
        }
        throw new UnsupportedOperationException("Unknown member type: " + member.getClass());
    }

    private <T> T onSuperClass(ClassInfo classInfo, Function<ClassInfo, T> f) {
        ClassInfo superClassInfo;
        Type superType = classInfo.superClassType();
        if (superType != null && !this.vetoedClassName(superType.name().toString()) && (superClassInfo = this.jandexIndex.getClassByName(superType.name())) != null) {
            return f.apply(superClassInfo);
        }
        return null;
    }

    private boolean isGetterMethod(MethodInfo methodInfo) {
        String methodName = methodInfo.name();
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && methodInfo.parametersCount() == 0 && (methodName.startsWith("get") || methodName.startsWith("is"));
    }

    private void throwExceptionForEmptyBean(String beanClassName, MethodCreator serialize, ResultHandle jsonGenerator) {
        String serializationFeatureClassName = SerializationFeature.class.getName();
        ResultHandle serializerProvider = serialize.getMethodParam(2);
        MethodDescriptor isEnabled = MethodDescriptor.ofMethod((String)SerializerProvider.class.getName(), (String)"isEnabled", (String)"boolean", (String[])new String[]{serializationFeatureClassName});
        FieldDescriptor failField = FieldDescriptor.of((String)serializationFeatureClassName, (String)"FAIL_ON_EMPTY_BEANS", (String)serializationFeatureClassName);
        ResultHandle failOnEmptyBeans = serialize.readStaticField(failField);
        ResultHandle isFailEnabled = serialize.invokeVirtualMethod(isEnabled, serializerProvider, new ResultHandle[]{failOnEmptyBeans});
        BytecodeCreator isFailEnabledBranch = serialize.ifTrue(isFailEnabled).trueBranch();
        ResultHandle javaType = isFailEnabledBranch.invokeStaticMethod(MethodDescriptor.ofMethod(SimpleType.class, (String)"constructUnsafe", SimpleType.class, (Class[])new Class[]{Class.class}), new ResultHandle[]{isFailEnabledBranch.loadClass(beanClassName)});
        MethodDescriptor exceptionConstructor = MethodDescriptor.ofMethod(InvalidDefinitionException.class, (String)"from", InvalidDefinitionException.class, (Class[])new Class[]{JsonGenerator.class, String.class, JavaType.class});
        String errorMsg = String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", beanClassName);
        ResultHandle invalidException = isFailEnabledBranch.invokeStaticMethod(exceptionConstructor, new ResultHandle[]{jsonGenerator, isFailEnabledBranch.load(errorMsg), javaType});
        isFailEnabledBranch.throwException(invalidException);
    }

    private MethodInfo getterMethodInfo(ClassInfo classInfo, FieldInfo fieldInfo) {
        MethodInfo namedAccessor = this.findMethod(classInfo, fieldInfo.name(), new Type[0]);
        if (namedAccessor != null) {
            return namedAccessor;
        }
        String methodName = (this.isBooleanType(fieldInfo.type().name().toString()) ? "is" : "get") + this.ucFirst(fieldInfo.name());
        return this.findMethod(classInfo, methodName, new Type[0]);
    }

    private MethodInfo findMethod(ClassInfo classInfo, String methodName, Type ... parameters) {
        MethodInfo method = classInfo.method(methodName, parameters);
        return method != null ? method : this.onSuperClass(classInfo, superClassInfo -> this.findMethod((ClassInfo)superClassInfo, methodName, parameters));
    }

    private String ucFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private boolean isBooleanType(String type) {
        return type.equals("boolean") || type.equals("java.lang.Boolean");
    }

    private boolean vetoedClassName(String className) {
        return className.startsWith("java.") || className.startsWith("jakarta.") || className.startsWith("io.vertx.core.json.");
    }
}

