/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.common.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.resteasy.reactive.common.runtime.ArcBeanFactory;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.spi.BeanFactory;

@Recorder
public class ResteasyReactiveCommonRecorder {
    private static final Map<String, Class<?>> primitiveTypes;

    public <T> BeanFactory<T> factory(String targetClass, BeanContainer beanContainer) {
        return new ArcBeanFactory<T>(ResteasyReactiveCommonRecorder.loadClass(targetClass), beanContainer);
    }

    public void registerWriter(Serialisers serialisers, String entityClassName, ResourceWriter writer) {
        serialisers.addWriter(ResteasyReactiveCommonRecorder.loadClass(entityClassName), writer);
    }

    public void registerReader(Serialisers serialisers, String entityClassName, ResourceReader reader) {
        serialisers.addReader(ResteasyReactiveCommonRecorder.loadClass(entityClassName), reader);
    }

    protected static <T> Class<T> loadClass(String name) {
        if (primitiveTypes.containsKey(name)) {
            return primitiveTypes.get(name);
        }
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        HashMap<String, Class<Comparable<Byte>>> prims = new HashMap<String, Class<Comparable<Byte>>>();
        prims.put(Byte.TYPE.getName(), Byte.TYPE);
        prims.put(Boolean.TYPE.getName(), Boolean.TYPE);
        prims.put(Character.TYPE.getName(), Character.TYPE);
        prims.put(Short.TYPE.getName(), Short.TYPE);
        prims.put(Integer.TYPE.getName(), Integer.TYPE);
        prims.put(Float.TYPE.getName(), Float.TYPE);
        prims.put(Double.TYPE.getName(), Double.TYPE);
        prims.put(Long.TYPE.getName(), Long.TYPE);
        primitiveTypes = Collections.unmodifiableMap(prims);
    }
}

