/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.Unremovable;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.server.deployment.GeneratorUtils;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveServerDotNames;
import io.quarkus.resteasy.reactive.server.runtime.filters.FilterUtil;
import io.quarkus.resteasy.reactive.server.runtime.filters.PreventAbortResteasyReactiveContainerRequestContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.HttpHeadersImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerResponseFilter;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

final class CustomFilterGenerator {
    private CustomFilterGenerator() {
    }

    static String generateContainerRequestFilter(MethodInfo targetMethod, ClassOutput classOutput) {
        String generatedClassName;
        block11: {
            ReturnType returnType = CustomFilterGenerator.determineRequestFilterReturnType(targetMethod);
            CustomFilterGenerator.checkModifiers(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
            generatedClassName = CustomFilterGenerator.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER);
            DotName declaringClassName = targetMethod.declaringClass().name();
            try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).interfaces(new Class[]{CustomFilterGenerator.determineRequestInterfaceType(returnType)}).build();){
                cc.addAnnotation(Singleton.class);
                cc.addAnnotation(Unremovable.class);
                FieldDescriptor delegateField = ((FieldCreator)cc.getFieldCreator("delegate", declaringClassName.toString()).setModifiers(18)).getFieldDescriptor();
                MethodCreator ctor = cc.getMethodCreator("<init>", Void.TYPE, new Object[]{declaringClassName.toString()});
                ctor.setModifiers(1);
                ctor.addAnnotation(Inject.class);
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                ResultHandle self = ctor.getThis();
                ResultHandle config = ctor.getMethodParam(0);
                ctor.writeInstanceField(delegateField, self, config);
                ctor.returnValue(null);
                if (returnType == ReturnType.VOID || returnType == ReturnType.OPTIONAL_RESPONSE || returnType == ReturnType.RESPONSE) {
                    MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ContainerRequestContext.class});
                    ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                    ResultHandle resultHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getRequestFilterResultHandles(targetMethod, declaringClassName, filterMethod, CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle)));
                    if (returnType == ReturnType.OPTIONAL_RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleOptional", Void.TYPE, (Class[])new Class[]{Optional.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    } else if (returnType == ReturnType.RESPONSE) {
                        filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleResponse", Void.TYPE, (Class[])new Class[]{Response.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{resultHandle, rrContainerReqCtxHandle});
                    }
                    filterMethod.returnValue(null);
                    break block11;
                }
                if (returnType == ReturnType.UNI_VOID || returnType == ReturnType.UNI_RESPONSE) {
                    MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class});
                    ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                    ResultHandle uniHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getRequestFilterResultHandles(targetMethod, declaringClassName, filterMethod, CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle)));
                    filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)(returnType == ReturnType.UNI_VOID ? "handleUniVoid" : "handleUniResponse"), Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{uniHandle, rrContainerReqCtxHandle});
                    filterMethod.returnValue(null);
                    break block11;
                }
                throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
            }
        }
        return generatedClassName;
    }

    private static ResultHandle[] getRequestFilterResultHandles(MethodInfo targetMethod, DotName declaringClassName, MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle[] targetMethodParamHandles = new ResultHandle[targetMethod.parameters().size()];
        for (int i = 0; i < targetMethod.parameters().size(); ++i) {
            Type param = (Type)targetMethod.parameters().get(i);
            DotName paramDotName = param.name();
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.newInstance(MethodDescriptor.ofConstructor(PreventAbortResteasyReactiveContainerRequestContext.class, (Class[])new Class[]{ContainerRequestContext.class}), new ResultHandle[]{filterMethod.getMethodParam(0)});
                continue;
            }
            if (ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.checkCast(filterMethod.getMethodParam(0), ResteasyReactiveContainerRequestContext.class);
                continue;
            }
            if (ResteasyReactiveDotNames.URI_INFO.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getUriInfo", ResteasyReactiveDotNames.URI_INFO);
                continue;
            }
            if (ResteasyReactiveDotNames.HTTP_HEADERS.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getHttpHeaders", HttpHeadersImpl.class);
                continue;
            }
            if (ResteasyReactiveDotNames.REQUEST.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getRequest", ResteasyReactiveDotNames.REQUEST);
                continue;
            }
            if (QuarkusResteasyReactiveDotNames.HTTP_SERVER_REQUEST.equals((Object)paramDotName)) {
                ResultHandle routingContextHandle = GeneratorUtils.routingContextHandler(filterMethod, rrReqCtxHandle);
                targetMethodParamHandles[i] = filterMethod.invokeInterfaceMethod(MethodDescriptor.ofMethod(RoutingContext.class, (String)"request", HttpServerRequest.class, (Class[])new Class[0]), routingContextHandle, new ResultHandle[0]);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getSimpleResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveServerDotNames.ROUTING_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = GeneratorUtils.routingContextHandler(filterMethod, rrReqCtxHandle);
                continue;
            }
            String parameterName = targetMethod.parameterName(i);
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + declaringClassName + "' is not allowed");
        }
        return targetMethodParamHandles;
    }

    static String generateContainerResponseFilter(MethodInfo targetMethod, ClassOutput classOutput) {
        ReturnType returnType = CustomFilterGenerator.determineResponseFilterReturnType(targetMethod);
        CustomFilterGenerator.checkModifiers(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        String generatedClassName = CustomFilterGenerator.getGeneratedClassName(targetMethod, ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER);
        DotName declaringClassName = targetMethod.declaringClass().name();
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).interfaces(new Class[]{CustomFilterGenerator.determineResponseInterfaceType(returnType)}).build();){
            cc.addAnnotation(Singleton.class);
            cc.addAnnotation(Unremovable.class);
            FieldDescriptor delegateField = ((FieldCreator)cc.getFieldCreator("delegate", declaringClassName.toString()).setModifiers(18)).getFieldDescriptor();
            MethodCreator ctor = cc.getMethodCreator("<init>", Void.TYPE, new Object[]{declaringClassName.toString()});
            ctor.setModifiers(1);
            ctor.addAnnotation(Inject.class);
            ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
            ResultHandle self = ctor.getThis();
            ResultHandle config = ctor.getMethodParam(0);
            ctor.writeInstanceField(delegateField, self, config);
            ctor.returnValue(null);
            if (returnType == ReturnType.VOID) {
                MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ContainerRequestContext.class, ContainerResponseContext.class});
                ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                ResultHandle rrReqCtxHandle = CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle);
                filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getResponseFilterResultHandles(targetMethod, declaringClassName, filterMethod, rrReqCtxHandle));
                filterMethod.returnValue(null);
            } else if (returnType == ReturnType.UNI_VOID) {
                MethodCreator filterMethod = cc.getMethodCreator("filter", Void.TYPE, new Class[]{ResteasyReactiveContainerRequestContext.class, ContainerResponseContext.class});
                ResultHandle rrContainerReqCtxHandle = CustomFilterGenerator.getRRContainerReqCtxHandle(filterMethod, 0);
                ResultHandle rrReqCtxHandle = CustomFilterGenerator.getRRReqCtxHandle(filterMethod, rrContainerReqCtxHandle);
                ResultHandle uniHandle = filterMethod.invokeVirtualMethod(targetMethod, filterMethod.readInstanceField(delegateField, filterMethod.getThis()), CustomFilterGenerator.getResponseFilterResultHandles(targetMethod, declaringClassName, filterMethod, rrReqCtxHandle));
                filterMethod.invokeStaticMethod(MethodDescriptor.ofMethod(FilterUtil.class, (String)"handleUniVoid", Void.TYPE, (Class[])new Class[]{Uni.class, ResteasyReactiveContainerRequestContext.class}), new ResultHandle[]{uniHandle, rrContainerReqCtxHandle});
                filterMethod.returnValue(null);
            }
        }
        return generatedClassName;
    }

    private static ResultHandle[] getResponseFilterResultHandles(MethodInfo targetMethod, DotName declaringClassName, MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle[] targetMethodParamHandles = new ResultHandle[targetMethod.parameters().size()];
        for (int i = 0; i < targetMethod.parameters().size(); ++i) {
            ResultHandle routingContextHandle;
            Type param = (Type)targetMethod.parameters().get(i);
            DotName paramDotName = param.name();
            if (ResteasyReactiveDotNames.CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.newInstance(MethodDescriptor.ofConstructor(PreventAbortResteasyReactiveContainerRequestContext.class, (Class[])new Class[]{ContainerRequestContext.class}), new ResultHandle[]{filterMethod.getMethodParam(0)});
                continue;
            }
            if (ResteasyReactiveServerDotNames.QUARKUS_REST_CONTAINER_REQUEST_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.checkCast(filterMethod.getMethodParam(0), ResteasyReactiveContainerRequestContext.class);
                continue;
            }
            if (ResteasyReactiveDotNames.CONTAINER_RESPONSE_CONTEXT.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = filterMethod.getMethodParam(1);
                continue;
            }
            if (QuarkusResteasyReactiveDotNames.HTTP_SERVER_REQUEST.equals((Object)paramDotName)) {
                routingContextHandle = GeneratorUtils.routingContextHandler(filterMethod, rrReqCtxHandle);
                targetMethodParamHandles[i] = filterMethod.invokeInterfaceMethod(MethodDescriptor.ofMethod(RoutingContext.class, (String)"request", HttpServerRequest.class, (Class[])new Class[0]), routingContextHandle, new ResultHandle[0]);
                continue;
            }
            if (QuarkusResteasyReactiveDotNames.HTTP_SERVER_RESPONSE.equals((Object)paramDotName)) {
                routingContextHandle = GeneratorUtils.routingContextHandler(filterMethod, rrReqCtxHandle);
                targetMethodParamHandles[i] = filterMethod.invokeInterfaceMethod(MethodDescriptor.ofMethod(RoutingContext.class, (String)"response", HttpServerResponse.class, (Class[])new Class[0]), routingContextHandle, new ResultHandle[0]);
                continue;
            }
            if (ResteasyReactiveDotNames.RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveServerDotNames.SIMPLIFIED_RESOURCE_INFO.equals((Object)paramDotName)) {
                targetMethodParamHandles[i] = CustomFilterGenerator.getSimpleResourceInfoHandle(filterMethod, rrReqCtxHandle);
                continue;
            }
            if (ResteasyReactiveDotNames.THROWABLE.equals((Object)paramDotName)) {
                GeneratorUtils.paramHandleFromReqContextMethod(filterMethod, rrReqCtxHandle, targetMethodParamHandles, i, "getThrowable", ResteasyReactiveDotNames.THROWABLE);
                continue;
            }
            String parameterName = targetMethod.parameterName(i);
            throw new RuntimeException("Parameter '" + parameterName + "' of method '" + targetMethod.name() + " of class '" + declaringClassName + "' is not allowed");
        }
        return targetMethodParamHandles;
    }

    private static ResultHandle getRRContainerReqCtxHandle(MethodCreator filter, int containerReqCtxParamIndex) {
        ResultHandle containerReqCtxHandle = filter.getMethodParam(containerReqCtxParamIndex);
        return filter.checkCast(containerReqCtxHandle, ResteasyReactiveContainerRequestContext.class);
    }

    private static ResultHandle getRRReqCtxHandle(MethodCreator filter, ResultHandle rrContainerReqCtxHandle) {
        ResultHandle rrCtxHandle = filter.invokeInterfaceMethod(MethodDescriptor.ofMethod(ResteasyReactiveContainerRequestContext.class, (String)"getServerRequestContext", ServerRequestContext.class, (Class[])new Class[0]), rrContainerReqCtxHandle, new ResultHandle[0]);
        return filter.checkCast(rrCtxHandle, ResteasyReactiveRequestContext.class);
    }

    private static AssignableResultHandle getResourceInfoHandle(MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(filterMethod, rrReqCtxHandle);
        AssignableResultHandle resourceInfo = filterMethod.createVariable(ResteasyReactiveResourceInfo.class);
        BranchResult ifNullBranch = filterMethod.ifNull(runtimeResourceHandle);
        ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
        ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getLazyMethod", ResteasyReactiveResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
        return resourceInfo;
    }

    private static AssignableResultHandle getSimpleResourceInfoHandle(MethodCreator filterMethod, ResultHandle rrReqCtxHandle) {
        ResultHandle runtimeResourceHandle = GeneratorUtils.runtimeResourceHandle(filterMethod, rrReqCtxHandle);
        AssignableResultHandle resourceInfo = filterMethod.createVariable(SimpleResourceInfo.class);
        BranchResult ifNullBranch = filterMethod.ifNull(runtimeResourceHandle);
        ifNullBranch.trueBranch().assign(resourceInfo, ifNullBranch.trueBranch().readStaticField(FieldDescriptor.of(SimpleResourceInfo.NullValues.class, (String)"INSTANCE", SimpleResourceInfo.NullValues.class)));
        ifNullBranch.falseBranch().assign(resourceInfo, ifNullBranch.falseBranch().invokeVirtualMethod(MethodDescriptor.ofMethod(RuntimeResource.class, (String)"getSimplifiedResourceInfo", SimpleResourceInfo.class, (Class[])new Class[0]), runtimeResourceHandle, new ResultHandle[0]));
        return resourceInfo;
    }

    private static String getGeneratedClassName(MethodInfo targetMethod, DotName annotationDotName) {
        DotName declaringClassName = targetMethod.declaringClass().name();
        return declaringClassName.toString() + "$Generated" + annotationDotName.withoutPackagePrefix() + "$" + targetMethod.name();
    }

    private static void checkModifiers(MethodInfo info, DotName annotationDotName) {
        if ((info.flags() & 2) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + info.declaringClass().name() + "' cannot be private as it is annotated with '@" + annotationDotName + "'");
        }
        if ((info.flags() & 8) != 0) {
            throw new RuntimeException("Method '" + info.name() + " of class '" + info.declaringClass().name() + "' cannot be static as it is annotated with '@" + annotationDotName + "'");
        }
    }

    private static ReturnType determineRequestFilterReturnType(MethodInfo targetMethod) {
        if (targetMethod.returnType().kind() == Type.Kind.VOID) {
            return ReturnType.VOID;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterizedType = targetMethod.returnType().asParameterizedType();
            if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1) {
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.VOID)) {
                    return ReturnType.UNI_VOID;
                }
                if (((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                    return ReturnType.UNI_RESPONSE;
                }
            } else if (parameterizedType.name().equals((Object)ResteasyReactiveDotNames.OPTIONAL) && parameterizedType.arguments().size() == 1 && ((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                return ReturnType.OPTIONAL_RESPONSE;
            }
        } else if (targetMethod.returnType().name().equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
            return ReturnType.RESPONSE;
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + targetMethod.declaringClass().name() + "' cannot be used as a request filter as it does not declare 'void', Optional<Response>, 'Uni<Void>' or 'Uni<Response>' as its return type");
    }

    private static ReturnType determineResponseFilterReturnType(MethodInfo targetMethod) {
        ParameterizedType parameterizedType;
        if (targetMethod.returnType().kind() == Type.Kind.VOID) {
            return ReturnType.VOID;
        }
        if (targetMethod.returnType().kind() == Type.Kind.PARAMETERIZED_TYPE && (parameterizedType = targetMethod.returnType().asParameterizedType()).name().equals((Object)ResteasyReactiveDotNames.UNI) && parameterizedType.arguments().size() == 1 && ((Type)parameterizedType.arguments().get(0)).name().equals((Object)ResteasyReactiveDotNames.VOID)) {
            return ReturnType.UNI_VOID;
        }
        throw new RuntimeException("Method '" + targetMethod.name() + " of class '" + targetMethod.declaringClass().name() + "' cannot be used as a response filter as it does not declare 'void' or 'Uni<Void>' as its return type");
    }

    private static Class<?> determineRequestInterfaceType(ReturnType returnType) {
        if (returnType == ReturnType.VOID || returnType == ReturnType.OPTIONAL_RESPONSE || returnType == ReturnType.RESPONSE) {
            return ContainerRequestFilter.class;
        }
        if (returnType == ReturnType.UNI_VOID || returnType == ReturnType.UNI_RESPONSE) {
            return ResteasyReactiveContainerRequestFilter.class;
        }
        throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
    }

    private static Class<?> determineResponseInterfaceType(ReturnType returnType) {
        if (returnType == ReturnType.VOID) {
            return ContainerResponseFilter.class;
        }
        if (returnType == ReturnType.UNI_VOID) {
            return ResteasyReactiveContainerResponseFilter.class;
        }
        throw new IllegalStateException("ReturnType: '" + returnType + "' is not supported");
    }

    private static enum ReturnType {
        VOID,
        RESPONSE,
        OPTIONAL_RESPONSE,
        UNI_VOID,
        UNI_RESPONSE;

    }
}

