/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.observability.ObservabilityCustomizer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;

public class ObservabilityProcessor {
    @BuildStep
    MethodScannerBuildItem integrateObservability(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        boolean integrationNeeded;
        boolean bl = integrationNeeded = capabilities.isPresent("io.quarkus.opentelemetry.tracer") || metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
        if (!integrationNeeded) {
            return null;
        }
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                return Collections.singletonList(new ObservabilityCustomizer());
            }
        });
    }
}

