/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsContributorBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ContextResolversBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.CustomFilterGenerator;
import io.quarkus.resteasy.reactive.server.deployment.ExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ParamConverterProvidersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveServerDotNames;
import io.quarkus.resteasy.reactive.server.deployment.ServerExceptionMapperGenerator;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.ContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.ContextResolverBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerRequestFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerResponseFilterBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.JaxrsFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.ParamConverterBuildItem;
import io.quarkus.runtime.BlockingOperationNotAllowedException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.core.BlockingNotAllowedException;
import org.jboss.resteasy.reactive.common.model.ResourceContextResolver;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceParamConverterProvider;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveInterceptorScanner;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.processor.scanning.AsyncReturnTypeScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.CacheControlScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveContextResolverScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveExceptionMappingScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveFeatureScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveParamConverterScanner;

public class ResteasyReactiveScanningProcessor {
    @BuildStep
    public MethodScannerBuildItem asyncSupport() {
        return new MethodScannerBuildItem((MethodScanner)new AsyncReturnTypeScanner());
    }

    @BuildStep
    public MethodScannerBuildItem cacheControlSupport() {
        return new MethodScannerBuildItem((MethodScanner)new CacheControlScanner());
    }

    @BuildStep
    public ResourceInterceptorsContributorBuildItem scanForInterceptors(final CombinedIndexBuildItem combinedIndexBuildItem, final ApplicationResultBuildItem applicationResultBuildItem) {
        return new ResourceInterceptorsContributorBuildItem((Consumer)new Consumer<ResourceInterceptors>(){

            @Override
            public void accept(ResourceInterceptors interceptors) {
                ResteasyReactiveInterceptorScanner.scanForInterceptors((ResourceInterceptors)interceptors, (IndexView)combinedIndexBuildItem.getIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
            }
        });
    }

    @BuildStep
    public ExceptionMappersBuildItem scanForExceptionMappers(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<ExceptionMapperBuildItem> mappers, Capabilities capabilities) {
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder().setUnremovable();
        ExceptionMapping exceptions = ResteasyReactiveExceptionMappingScanner.scanForExceptionMappers((IndexView)combinedIndexBuildItem.getComputingIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
        exceptions.addBlockingProblem(BlockingOperationNotAllowedException.class);
        exceptions.addBlockingProblem(BlockingNotAllowedException.class);
        if (capabilities.isPresent("io.quarkus.hibernate.reactive")) {
            exceptions.addNonBlockingProblem((Predicate)new ExceptionMapping.ExceptionTypeAndMessageContainsPredicate(IllegalStateException.class, "HR000068"));
        }
        for (Map.Entry i : exceptions.getMappers().entrySet()) {
            beanBuilder.addBeanClass(((ResourceExceptionMapper)i.getValue()).getClassName());
        }
        for (ExceptionMapperBuildItem additionalExceptionMapper : mappers) {
            if (additionalExceptionMapper.isRegisterAsBean()) {
                beanBuilder.addBeanClass(additionalExceptionMapper.getClassName());
            } else {
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{additionalExceptionMapper.getClassName()}));
            }
            int priority = 5000;
            if (additionalExceptionMapper.getPriority() != null) {
                priority = additionalExceptionMapper.getPriority();
            }
            ResourceExceptionMapper mapper = new ResourceExceptionMapper();
            mapper.setPriority(priority);
            mapper.setClassName(additionalExceptionMapper.getClassName());
            try {
                exceptions.addExceptionMapper(Class.forName(additionalExceptionMapper.getHandledExceptionName(), false, Thread.currentThread().getContextClassLoader()), mapper);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load handled exception type " + additionalExceptionMapper.getHandledExceptionName(), e);
            }
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.build());
        return new ExceptionMappersBuildItem(exceptions);
    }

    @BuildStep
    public ParamConverterProvidersBuildItem scanForParamConverters(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, ApplicationResultBuildItem applicationResultBuildItem, List<ParamConverterBuildItem> paramConverterBuildItems) {
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder().setUnremovable();
        ParamConverterProviders paramConverterProviders = ResteasyReactiveParamConverterScanner.scanForParamConverters((IndexView)combinedIndexBuildItem.getComputingIndex(), (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (ResourceParamConverterProvider i : paramConverterProviders.getParamConverterProviders()) {
            beanBuilder.addBeanClass(i.getClassName());
        }
        for (ParamConverterBuildItem additionalParamConverter : paramConverterBuildItems) {
            if (additionalParamConverter.isRegisterAsBean()) {
                beanBuilder.addBeanClass(additionalParamConverter.getClassName());
            } else {
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{additionalParamConverter.getClassName()}));
            }
            int priority = 5000;
            if (additionalParamConverter.getPriority() != null) {
                priority = additionalParamConverter.getPriority();
            }
            ResourceParamConverterProvider provider = new ResourceParamConverterProvider();
            provider.setPriority(Integer.valueOf(priority));
            provider.setClassName(additionalParamConverter.getClassName());
            paramConverterProviders.addParamConverterProviders(provider);
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.build());
        return new ParamConverterProvidersBuildItem(paramConverterProviders);
    }

    @BuildStep
    public void scanForDynamicFeatures(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<DynamicFeatureBuildItem> dynamicFeatureBuildItemBuildProducer) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        Set features = ResteasyReactiveFeatureScanner.scanForDynamicFeatures((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (String dynamicFeatureClass : features) {
            dynamicFeatureBuildItemBuildProducer.produce((BuildItem)new DynamicFeatureBuildItem(dynamicFeatureClass, true));
        }
    }

    @BuildStep
    public void scanForFeatures(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<JaxrsFeatureBuildItem> featureBuildItemBuildProducer) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        Set features = ResteasyReactiveFeatureScanner.scanForFeatures((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (String feature : features) {
            featureBuildItemBuildProducer.produce((BuildItem)new JaxrsFeatureBuildItem(feature, true));
        }
    }

    @BuildStep
    public ContextResolversBuildItem scanForContextResolvers(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<ContextResolverBuildItem> additionalResolvers) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        AdditionalBeanBuildItem.Builder beanBuilder = AdditionalBeanBuildItem.builder().setUnremovable();
        ContextResolvers resolvers = ResteasyReactiveContextResolverScanner.scanForContextResolvers((IndexView)index, (ApplicationScanningResult)applicationResultBuildItem.getResult());
        for (Map.Entry entry : resolvers.getResolvers().entrySet()) {
            for (ResourceContextResolver i : (List)entry.getValue()) {
                beanBuilder.addBeanClass(i.getClassName());
            }
        }
        for (ContextResolverBuildItem i : additionalResolvers) {
            if (i.isRegisterAsBean()) {
                beanBuilder.addBeanClass(i.getClassName());
            } else {
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{i.getClassName()}));
            }
            ResourceContextResolver resolver = new ResourceContextResolver();
            resolver.setClassName(i.getClassName());
            resolver.setMediaTypeStrings(i.getMediaTypes());
            try {
                resolvers.addContextResolver(Class.forName(i.getProvidedType(), false, Thread.currentThread().getContextClassLoader()), resolver);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to load handled exception type " + i.getProvidedType(), e);
            }
        }
        additionalBeanBuildItemBuildProducer.produce((BuildItem)beanBuilder.build());
        return new ContextResolversBuildItem(resolvers);
    }

    @BuildStep
    public void scanForParamConverters(CombinedIndexBuildItem combinedIndexBuildItem, ApplicationResultBuildItem applicationResultBuildItem, BuildProducer<ParamConverterBuildItem> paramConverterBuildItemBuildProducer) {
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        Collection paramConverterProviders = index.getAllKnownImplementors(ResteasyReactiveDotNames.PARAM_CONVERTER_PROVIDER);
        for (ClassInfo converterClass : paramConverterProviders) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationResultBuildItem.getResult().keepProvider(converterClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            AnnotationInstance priorityInstance = converterClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            paramConverterBuildItemBuildProducer.produce((BuildItem)new ParamConverterBuildItem(converterClass.name().toString(), priorityInstance != null ? priorityInstance.value().asInt() : 5000, true));
        }
    }

    @BuildStep
    public void handleCustomAnnotatedMethods(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBean, List<CustomContainerRequestFilterBuildItem> customContainerRequestFilters, List<CustomContainerResponseFilterBuildItem> customContainerResponseFilters, List<CustomExceptionMapperBuildItem> customExceptionMappers, BuildProducer<ContainerRequestFilterBuildItem> additionalContainerRequestFilters, BuildProducer<ContainerResponseFilterBuildItem> additionalContainerResponseFilters, BuildProducer<ExceptionMapperBuildItem> additionalExceptionMappers, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        AnnotationValue priorityValue;
        ContainerRequestFilterBuildItem.Builder builder;
        MethodInfo methodInfo;
        IndexView index = combinedIndexBuildItem.getComputingIndex();
        AdditionalBeanBuildItem.Builder additionalBeans = AdditionalBeanBuildItem.builder();
        if (!(customContainerRequestFilters.isEmpty() && customContainerResponseFilters.isEmpty() && customExceptionMappers.isEmpty())) {
            Indexer indexer = new Indexer();
            HashSet additionalIndex = new HashSet();
            for (CustomContainerRequestFilterBuildItem customContainerRequestFilterBuildItem : customContainerRequestFilters) {
                IndexingUtil.indexClass((String)customContainerRequestFilterBuildItem.getClassName(), (Indexer)indexer, (IndexView)combinedIndexBuildItem.getIndex(), additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            for (CustomContainerResponseFilterBuildItem customContainerResponseFilterBuildItem : customContainerResponseFilters) {
                IndexingUtil.indexClass((String)customContainerResponseFilterBuildItem.getClassName(), (Indexer)indexer, (IndexView)combinedIndexBuildItem.getIndex(), additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            for (CustomExceptionMapperBuildItem customExceptionMapperBuildItem : customExceptionMappers) {
                IndexingUtil.indexClass((String)customExceptionMapperBuildItem.getClassName(), (Indexer)indexer, (IndexView)combinedIndexBuildItem.getIndex(), additionalIndex, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            index = CompositeIndex.create((IndexView[])new IndexView[]{index, indexer.complete()});
        }
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER)) {
            AnnotationValue nonBlockingRequiredValue;
            AnnotationValue preMatchingValue;
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            methodInfo = instance.target().asMethod();
            additionalBeans.addBeanClass(methodInfo.declaringClass().name().toString());
            String string = CustomFilterGenerator.generateContainerRequestFilter(methodInfo, (ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBean));
            builder = (ContainerRequestFilterBuildItem.Builder)new ContainerRequestFilterBuildItem.Builder(string).setRegisterAsBean(false);
            priorityValue = instance.value("priority");
            if (priorityValue != null) {
                builder.setPriority(Integer.valueOf(priorityValue.asInt()));
            }
            if ((preMatchingValue = instance.value("preMatching")) != null) {
                builder.setPreMatching(Boolean.valueOf(preMatchingValue.asBoolean()));
            }
            if ((nonBlockingRequiredValue = instance.value("nonBlocking")) != null) {
                builder.setNonBlockingRequired(Boolean.valueOf(nonBlockingRequiredValue.asBoolean()));
            }
            List annotations = methodInfo.annotations();
            HashSet<String> nameBindingNames = new HashSet<String>();
            for (AnnotationInstance annotation : annotations) {
                DotName annotationDotName;
                ClassInfo annotationClassInfo;
                if (ResteasyReactiveServerDotNames.SERVER_REQUEST_FILTER.equals((Object)annotation.name()) || (annotationClassInfo = index.getClassByName(annotationDotName = annotation.name())) == null || annotationClassInfo.classAnnotation(ResteasyReactiveDotNames.NAME_BINDING) == null) continue;
                nameBindingNames.add(annotationDotName.toString());
            }
            if (!nameBindingNames.isEmpty()) {
                builder.setNameBindingNames(nameBindingNames);
            }
            additionalContainerRequestFilters.produce((BuildItem)builder.build());
        }
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveServerDotNames.SERVER_RESPONSE_FILTER)) {
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            methodInfo = instance.target().asMethod();
            additionalBeans.addBeanClass(methodInfo.declaringClass().name().toString());
            String string = CustomFilterGenerator.generateContainerResponseFilter(methodInfo, (ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBean));
            builder = (ContainerResponseFilterBuildItem.Builder)new ContainerResponseFilterBuildItem.Builder(string).setRegisterAsBean(false);
            priorityValue = instance.value("priority");
            if (priorityValue != null) {
                builder.setPriority(Integer.valueOf(priorityValue.asInt()));
            }
            additionalContainerResponseFilters.produce((BuildItem)builder.build());
        }
        HashSet classLevelExceptionMappers = new HashSet(resourceScanningResultBuildItem.map(s -> s.getResult().getClassLevelExceptionMappers()).orElse(Collections.emptyList()));
        for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER)) {
            MethodInfo methodInfo2;
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD || classLevelExceptionMappers.contains(methodInfo2 = instance.target().asMethod())) continue;
            additionalBeans.addBeanClass(methodInfo2.declaringClass().name().toString());
            Map<String, String> generatedClassNames = ServerExceptionMapperGenerator.generateGlobalMapper(methodInfo2, (ClassOutput)new GeneratedBeanGizmoAdaptor(generatedBean));
            for (Map.Entry<String, String> entry : generatedClassNames.entrySet()) {
                ExceptionMapperBuildItem.Builder builder2 = new ExceptionMapperBuildItem.Builder(entry.getValue(), entry.getKey()).setRegisterAsBean(false);
                AnnotationValue priorityValue2 = instance.value("priority");
                if (priorityValue2 != null) {
                    builder2.setPriority(Integer.valueOf(priorityValue2.asInt()));
                }
                additionalExceptionMappers.produce((BuildItem)builder2.build());
            }
        }
        additionalBean.produce((BuildItem)additionalBeans.setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
    }
}

