/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Predicate;
import javax.ws.rs.core.Context;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.server.ServerRequestFilter;
import org.jboss.resteasy.reactive.server.ServerResponseFilter;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveContainerRequestContext;

public class ResteasyReactiveServerDotNames {
    public static final DotName CONTEXT = DotName.createSimple((String)Context.class.getName());
    public static final DotName SERVER_REQUEST_FILTER = DotName.createSimple((String)ServerRequestFilter.class.getName());
    public static final DotName SERVER_RESPONSE_FILTER = DotName.createSimple((String)ServerResponseFilter.class.getName());
    public static final DotName QUARKUS_REST_CONTAINER_REQUEST_CONTEXT = DotName.createSimple((String)ResteasyReactiveContainerRequestContext.class.getName());
    public static final DotName SIMPLIFIED_RESOURCE_INFO = DotName.createSimple((String)SimpleResourceInfo.class.getName());
    public static final DotName ROUTING_CONTEXT = DotName.createSimple((String)RoutingContext.class.getName());
    public static final DotName JSON_IGNORE = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonIgnore");
    public static final DotName JSONB_TRANSIENT = DotName.createSimple((String)"javax.json.bind.annotation.JsonbTransient");
    public static final IgnoreTypeForReflectionPredicate IGNORE_TYPE_FOR_REFLECTION_PREDICATE = new IgnoreTypeForReflectionPredicate();
    public static final IgnoreFieldForReflectionPredicate IGNORE_FIELD_FOR_REFLECTION_PREDICATE = new IgnoreFieldForReflectionPredicate();
    public static final IgnoreMethodForReflectionPredicate IGNORE_METHOD_FOR_REFLECTION_PREDICATE = new IgnoreMethodForReflectionPredicate();
    private static final String[] PACKAGES_IGNORED_FOR_REFLECTION = new String[]{"javax.json.", "com.fasterxml.jackson.databind.", "javax.ws.rs.", "org.jboss.resteasy.reactive", "io.vertx.core.json.", "io.smallrye.mutiny."};

    private static class IgnoreMethodForReflectionPredicate
    implements Predicate<MethodInfo> {
        private IgnoreMethodForReflectionPredicate() {
        }

        @Override
        public boolean test(MethodInfo methodInfo) {
            return methodInfo.hasAnnotation(JSON_IGNORE) || methodInfo.hasAnnotation(JSONB_TRANSIENT);
        }
    }

    private static class IgnoreFieldForReflectionPredicate
    implements Predicate<FieldInfo> {
        private IgnoreFieldForReflectionPredicate() {
        }

        @Override
        public boolean test(FieldInfo fieldInfo) {
            return fieldInfo.hasAnnotation(JSON_IGNORE) || fieldInfo.hasAnnotation(JSONB_TRANSIENT);
        }
    }

    private static class IgnoreTypeForReflectionPredicate
    implements Predicate<DotName> {
        private IgnoreTypeForReflectionPredicate() {
        }

        @Override
        public boolean test(DotName dotName) {
            if (ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName)) {
                return true;
            }
            String name = dotName.toString();
            for (String packageName : PACKAGES_IGNORED_FOR_REFLECTION) {
                if (!name.startsWith(packageName)) continue;
                return true;
            }
            return false;
        }
    }
}

