/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.parameters.CookieParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.HeaderParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.MatrixParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.PathParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.QueryParamExtractor;

final class CustomResourceProducersGenerator {
    private static final DotName DOTNAME_REQUEST_SCOPED = DotName.createSimple((String)RequestScoped.class.getSimpleName());

    private CustomResourceProducersGenerator() {
    }

    public static void generate(Map<DotName, MethodInfo> resourcesThatNeedCustomProducer, Set<String> beanParamsThatNeedCustomProducer, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeanBuildItemBuildProducer);
        try (ClassCreator c = new ClassCreator((ClassOutput)classOutput, "io.quarkus.rest.cdi.ResourceWithJaxRsCtorParamsProducer", null, Object.class.getName(), new String[0]);){
            ResultHandle resultHandle;
            ResultHandle extractorHandle;
            ResultHandle quarkusRestContextHandle;
            c.addAnnotation(Singleton.class);
            MethodCreator getContextMethodCreator = c.getMethodCreator("getContext", ResteasyReactiveRequestContext.class, new Class[0]);
            MethodCreator getHeaderParamMethodCreator = c.getMethodCreator("getHeaderParam", String.class, new Class[]{String.class});
            MethodCreator getQueryParamMethodCreator = c.getMethodCreator("getQueryParam", String.class, new Class[]{String.class});
            MethodCreator getPathParamMethodCreator = c.getMethodCreator("getPathParam", String.class, new Class[]{Integer.TYPE});
            MethodCreator getMatrixParamMethodCreator = c.getMethodCreator("getMatrixParam", String.class, new Class[]{String.class});
            MethodCreator getCookieParamMethodCreator = c.getMethodCreator("getCookieParam", String.class, new Class[]{String.class});
            try (MethodCreator m = getContextMethodCreator;){
                m.setModifiers(2);
                ResultHandle otherHttpContextObjectHandle = m.invokeStaticMethod(MethodDescriptor.ofMethod(CurrentRequestManager.class, (String)"get", ResteasyReactiveRequestContext.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle result = m.checkCast(otherHttpContextObjectHandle, ResteasyReactiveRequestContext.class);
                m.returnValue(result);
            }
            m = getHeaderParamMethodCreator;
            try {
                m.setModifiers(2);
                quarkusRestContextHandle = m.invokeVirtualMethod(getContextMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[0]);
                extractorHandle = m.newInstance(MethodDescriptor.ofConstructor(HeaderParamExtractor.class, (Class[])new Class[]{String.class, Boolean.TYPE}), new ResultHandle[]{m.getMethodParam(0), m.load(true)});
                resultHandle = m.invokeVirtualMethod(MethodDescriptor.ofMethod(HeaderParamExtractor.class, (String)"extractParameter", Object.class, (Class[])new Class[]{ResteasyReactiveRequestContext.class}), extractorHandle, new ResultHandle[]{quarkusRestContextHandle});
                m.returnValue(resultHandle);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
            m = getQueryParamMethodCreator;
            try {
                m.setModifiers(2);
                quarkusRestContextHandle = m.invokeVirtualMethod(getContextMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[0]);
                extractorHandle = m.newInstance(MethodDescriptor.ofConstructor(QueryParamExtractor.class, (Class[])new Class[]{String.class, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{m.getMethodParam(0), m.load(true), m.load(false)});
                resultHandle = m.invokeVirtualMethod(MethodDescriptor.ofMethod(QueryParamExtractor.class, (String)"extractParameter", Object.class, (Class[])new Class[]{ResteasyReactiveRequestContext.class}), extractorHandle, new ResultHandle[]{quarkusRestContextHandle});
                m.returnValue(resultHandle);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
            m = getPathParamMethodCreator;
            try {
                m.setModifiers(2);
                quarkusRestContextHandle = m.invokeVirtualMethod(getContextMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[0]);
                extractorHandle = m.newInstance(MethodDescriptor.ofConstructor(PathParamExtractor.class, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE}), new ResultHandle[]{m.getMethodParam(0), m.load(false)});
                resultHandle = m.invokeVirtualMethod(MethodDescriptor.ofMethod(PathParamExtractor.class, (String)"extractParameter", Object.class, (Class[])new Class[]{ResteasyReactiveRequestContext.class}), extractorHandle, new ResultHandle[]{quarkusRestContextHandle});
                m.returnValue(resultHandle);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
            m = getMatrixParamMethodCreator;
            try {
                m.setModifiers(2);
                quarkusRestContextHandle = m.invokeVirtualMethod(getContextMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[0]);
                extractorHandle = m.newInstance(MethodDescriptor.ofConstructor(MatrixParamExtractor.class, (Class[])new Class[]{String.class, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{m.getMethodParam(0), m.load(true), m.load(false)});
                resultHandle = m.invokeVirtualMethod(MethodDescriptor.ofMethod(MatrixParamExtractor.class, (String)"extractParameter", Object.class, (Class[])new Class[]{ResteasyReactiveRequestContext.class}), extractorHandle, new ResultHandle[]{quarkusRestContextHandle});
                m.returnValue(resultHandle);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
            m = getCookieParamMethodCreator;
            try {
                m.setModifiers(2);
                quarkusRestContextHandle = m.invokeVirtualMethod(getContextMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[0]);
                extractorHandle = m.newInstance(MethodDescriptor.ofConstructor(CookieParamExtractor.class, (Class[])new Class[]{String.class}), new ResultHandle[]{m.getMethodParam(0)});
                resultHandle = m.invokeVirtualMethod(MethodDescriptor.ofMethod(CookieParamExtractor.class, (String)"extractParameter", Object.class, (Class[])new Class[]{ResteasyReactiveRequestContext.class}), extractorHandle, new ResultHandle[]{quarkusRestContextHandle});
                m.returnValue(resultHandle);
            }
            finally {
                if (m != null) {
                    m.close();
                }
            }
            for (Map.Entry<DotName, MethodInfo> entry : resourcesThatNeedCustomProducer.entrySet()) {
                DotName resourceDotName = entry.getKey();
                MethodInfo ctor = entry.getValue();
                List annotations = ctor.annotations();
                HashMap paramIndexToAnnotations = new HashMap();
                for (AnnotationInstance annotation : annotations) {
                    MethodParameterInfo methodParameterInfo;
                    ArrayList<AnnotationInstance> annotationsOfParam;
                    if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || (annotationsOfParam = (ArrayList<AnnotationInstance>)paramIndexToAnnotations.get((methodParameterInfo = annotation.target().asMethodParameter()).position())) != null) continue;
                    annotationsOfParam = new ArrayList<AnnotationInstance>(1);
                    annotationsOfParam.add(annotation);
                    paramIndexToAnnotations.put(methodParameterInfo.position(), annotationsOfParam);
                }
                ArrayList<CtorParamData> ctorParamData = new ArrayList<CtorParamData>(ctor.parameters().size());
                for (short i = 0; i < ctor.parameters().size(); i = (short)(i + 1)) {
                    CtorParamData.CustomProducerParameterType customProducerParameterType;
                    Type parameterType = (Type)ctor.parameters().get(i);
                    if (!paramIndexToAnnotations.containsKey(i)) {
                        ctorParamData.add(new CtorParamData(CtorParamData.CustomProducerParameterType.OTHER, parameterType));
                        continue;
                    }
                    List paramAnnotations = (List)paramIndexToAnnotations.get(i);
                    ArrayList<AnnotationInstance> jaxRSAnnotationsOfParam = new ArrayList<AnnotationInstance>(paramAnnotations.size());
                    for (AnnotationInstance paramAnnotation : paramAnnotations) {
                        if (!ResteasyReactiveDotNames.RESOURCE_CTOR_PARAMS_THAT_NEED_HANDLING.contains(paramAnnotation.name())) continue;
                        jaxRSAnnotationsOfParam.add(paramAnnotation);
                    }
                    if (jaxRSAnnotationsOfParam.isEmpty()) {
                        ctorParamData.add(new CtorParamData(CtorParamData.CustomProducerParameterType.OTHER, parameterType));
                        continue;
                    }
                    if (jaxRSAnnotationsOfParam.size() > 1) {
                        throw new IllegalArgumentException("Parameter: " + i + " of the constructor of class '" + resourceDotName + "' contains multiple JAX-RS annotations, which is not valid");
                    }
                    AnnotationInstance jaxRSAnnotationOfParam = (AnnotationInstance)jaxRSAnnotationsOfParam.iterator().next();
                    if (!parameterType.name().equals((Object)ResteasyReactiveDotNames.STRING)) {
                        throw new IllegalArgumentException("Parameter: " + i + " of the constructor of class '" + resourceDotName + "' which is annotated with '" + jaxRSAnnotationOfParam.name() + "' can only be of type String");
                    }
                    if (jaxRSAnnotationOfParam.name().equals((Object)ResteasyReactiveDotNames.QUERY_PARAM)) {
                        customProducerParameterType = CtorParamData.CustomProducerParameterType.QUERY;
                    } else if (jaxRSAnnotationOfParam.name().equals((Object)ResteasyReactiveDotNames.HEADER_PARAM)) {
                        customProducerParameterType = CtorParamData.CustomProducerParameterType.HEADER;
                    } else if (jaxRSAnnotationOfParam.name().equals((Object)ResteasyReactiveDotNames.PATH_PARAM)) {
                        customProducerParameterType = CtorParamData.CustomProducerParameterType.PATH;
                    } else if (jaxRSAnnotationOfParam.name().equals((Object)ResteasyReactiveDotNames.MATRIX_PARAM)) {
                        customProducerParameterType = CtorParamData.CustomProducerParameterType.MATRIX;
                    } else if (jaxRSAnnotationOfParam.name().equals((Object)ResteasyReactiveDotNames.COOKIE_PARAM)) {
                        customProducerParameterType = CtorParamData.CustomProducerParameterType.COOKIE;
                    } else {
                        throw new IllegalStateException("Unsupported type '" + jaxRSAnnotationOfParam.name() + "' used as an annotation in constructor of class '" + resourceDotName + "'");
                    }
                    String name = jaxRSAnnotationOfParam.value().asString();
                    ctorParamData.add(new CtorParamData(customProducerParameterType, parameterType, name));
                }
                ArrayList<String> producerMethodParameterTypes = new ArrayList<String>(ctor.parameters().size());
                for (CtorParamData ctorParamDatum : ctorParamData) {
                    if (ctorParamDatum.getCustomProducerParameterType() != CtorParamData.CustomProducerParameterType.OTHER) continue;
                    producerMethodParameterTypes.add(ctorParamDatum.getParameterType().name().toString());
                }
                String methodName = "producer_" + resourceDotName.withoutPackagePrefix() + HashUtil.sha1((String)resourceDotName.toString());
                MethodCreator m = c.getMethodCreator(methodName, resourceDotName.toString(), producerMethodParameterTypes.toArray(new String[0]));
                try {
                    m.addAnnotation(Produces.class);
                    m.addAnnotation(RequestScoped.class);
                    m.addAnnotation(Unremovable.class);
                    ArrayList<ResultHandle> ctorParamHandles = new ArrayList<ResultHandle>(ctorParamData.size());
                    int otherParamIndex = 0;
                    for (CtorParamData ctorParamDatum : ctorParamData) {
                        ResultHandle resultHandle2;
                        CtorParamData.CustomProducerParameterType type = ctorParamDatum.getCustomProducerParameterType();
                        if (type == CtorParamData.CustomProducerParameterType.OTHER) {
                            resultHandle2 = m.getMethodParam(otherParamIndex);
                            ++otherParamIndex;
                        } else if (type == CtorParamData.CustomProducerParameterType.HEADER) {
                            resultHandle2 = m.invokeVirtualMethod(getHeaderParamMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[]{m.load(ctorParamDatum.getAnnotationValue())});
                        } else if (type == CtorParamData.CustomProducerParameterType.QUERY) {
                            resultHandle2 = m.invokeVirtualMethod(getQueryParamMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[]{m.load(ctorParamDatum.getAnnotationValue())});
                        } else if (type == CtorParamData.CustomProducerParameterType.PATH) {
                            resultHandle2 = m.invokeVirtualMethod(getPathParamMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[]{m.load(0)});
                        } else if (type == CtorParamData.CustomProducerParameterType.MATRIX) {
                            resultHandle2 = m.invokeVirtualMethod(getMatrixParamMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[]{m.load(ctorParamDatum.getAnnotationValue())});
                        } else if (type == CtorParamData.CustomProducerParameterType.COOKIE) {
                            resultHandle2 = m.invokeVirtualMethod(getCookieParamMethodCreator.getMethodDescriptor(), m.getThis(), new ResultHandle[]{m.load(ctorParamDatum.getAnnotationValue())});
                        } else {
                            throw new IllegalStateException("Unknown type '" + type + "' used as an annotation in constructor of class '" + resourceDotName + "'");
                        }
                        ctorParamHandles.add(resultHandle2);
                    }
                    m.returnValue(m.newInstance(ctor, ctorParamHandles.toArray(new ResultHandle[0])));
                }
                finally {
                    if (m == null) continue;
                    m.close();
                }
            }
            additionalBeanBuildItemBuildProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(beanParamsThatNeedCustomProducer).build());
        }
    }

    private static class CtorParamData {
        private final CustomProducerParameterType customProducerParameterType;
        private final Type parameterType;
        private final String annotationValue;

        public CtorParamData(CustomProducerParameterType customProducerParameterType, Type parameterType) {
            this(customProducerParameterType, parameterType, null);
        }

        public CtorParamData(CustomProducerParameterType customProducerParameterType, Type parameterType, String annotationValue) {
            this.customProducerParameterType = customProducerParameterType;
            this.parameterType = parameterType;
            this.annotationValue = annotationValue;
        }

        public CustomProducerParameterType getCustomProducerParameterType() {
            return this.customProducerParameterType;
        }

        public Type getParameterType() {
            return this.parameterType;
        }

        public String getAnnotationValue() {
            return this.annotationValue;
        }

        private static enum CustomProducerParameterType {
            QUERY,
            HEADER,
            PATH,
            MATRIX,
            COOKIE,
            OTHER;

        }
    }
}

