/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.runtime.TemplateHtmlBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;

@Provider
@Priority(value=5001)
public class NotFoundExceptionMapper
implements ExceptionMapper<NotFoundException> {
    @Context
    private Registry registry = null;
    @Context
    private HttpHeaders headers;

    public Response toResponse(NotFoundException exception) {
        if (this.registry == null) {
            return this.respond();
        }
        Map bounded = null;
        if (this.registry instanceof ResourceMethodRegistry) {
            bounded = ((ResourceMethodRegistry)this.registry).getBounded();
        } else if (Proxy.isProxyClass(this.registry.getClass()) && this.registry.toString().startsWith(ResourceMethodRegistry.class.getName())) {
            try {
                bounded = (Map)Proxy.getInvocationHandler(this.registry).invoke(this.registry, ResourceMethodRegistry.class.getMethod("getBounded", new Class[0]), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bounded == null) {
            return this.respond();
        }
        List<ResourceDescription> descriptions = ResourceDescription.fromBoundResourceInvokers(bounded.entrySet());
        return this.respond(descriptions);
    }

    private Response respond() {
        if (this.headers.getAcceptableMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE)) {
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.errorMessage = "404 - Resource Not Found";
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMessage).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "No resources discovered");
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)sb.toString()).build();
    }

    private Response respond(List<ResourceDescription> descriptions) {
        if (this.headers.getAcceptableMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE)) {
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.errorMessage = "404 - Resource Not Found";
            errorMessage.existingResourcesDetails = descriptions;
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMessage).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "REST interface overview");
        sb.resourcesStart();
        for (ResourceDescription resource : descriptions) {
            sb.resourcePath(resource.basePath);
            for (MethodDescription method : resource.calls) {
                sb.method(method.method, method.fullPath);
                if (method.consumes != null) {
                    sb.consumes(method.consumes);
                }
                if (method.produces != null) {
                    sb.produces(method.produces);
                }
                sb.methodEnd();
            }
            sb.resourceEnd();
        }
        if (descriptions.isEmpty()) {
            sb.noResourcesFound();
        }
        sb.resourcesEnd();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)sb.toString()).build();
    }

    public static class ErrorMessage {
        public String errorMessage;
        public List<ResourceDescription> existingResourcesDetails;
    }

    public static final class ResourceDescription {
        public String basePath;
        public List<MethodDescription> calls;

        public ResourceDescription(String basePath) {
            this.basePath = basePath;
            this.calls = new ArrayList<MethodDescription>();
        }

        public void addMethod(String path, ResourceMethodInvoker method) {
            String produces = ResourceDescription.mostPreferredOrNull(method.getProduces());
            String consumes = ResourceDescription.mostPreferredOrNull(method.getConsumes());
            for (String verb : method.getHttpMethods()) {
                this.calls.add(new MethodDescription(verb, path, produces, consumes));
            }
        }

        private static String mostPreferredOrNull(MediaType[] mediaTypes) {
            if (mediaTypes == null || mediaTypes.length < 1) {
                return null;
            }
            return mediaTypes[0].toString();
        }

        public static List<ResourceDescription> fromBoundResourceInvokers(Set<Map.Entry<String, List<ResourceInvoker>>> bound) {
            HashMap<String, ResourceDescription> descriptions = new HashMap<String, ResourceDescription>();
            for (Map.Entry<String, List<ResourceInvoker>> entry : bound) {
                for (ResourceInvoker invoker : entry.getValue()) {
                    ResourceMethodInvoker method;
                    Class resourceClass;
                    Path path;
                    if (!(invoker instanceof ResourceMethodInvoker) || (path = (resourceClass = (method = (ResourceMethodInvoker)invoker).getResourceClass()).getAnnotation(Path.class)) == null) continue;
                    String basePath = path.value();
                    if (!descriptions.containsKey(basePath)) {
                        descriptions.put(basePath, new ResourceDescription(basePath));
                    }
                    String subPath = "";
                    for (Annotation annotation : method.getMethodAnnotations()) {
                        if (!annotation.annotationType().equals(Path.class)) continue;
                        subPath = ((Path)annotation).value();
                        break;
                    }
                    ((ResourceDescription)descriptions.get(basePath)).addMethod(basePath + subPath, method);
                }
            }
            return new LinkedList<ResourceDescription>(descriptions.values());
        }
    }

    public static final class MethodDescription {
        public String method;
        public String fullPath;
        public String produces;
        public String consumes;

        public MethodDescription(String method, String fullPath, String produces, String consumes) {
            this.method = method;
            this.fullPath = fullPath;
            this.produces = produces;
            this.consumes = consumes;
        }
    }
}

