/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.RequestFailer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;

@Priority(value=2000)
public class RolesAllowedFilter
implements ContainerRequestFilter {
    private final Set<String> allowedRoles;
    private final boolean allRolesAllowed;

    public RolesAllowedFilter(String ... allowedRoles) {
        this.allowedRoles = new HashSet<String>(Arrays.asList(allowedRoles));
        this.allRolesAllowed = this.allowedRoles.stream().anyMatch("*"::equals);
    }

    public void filter(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        boolean isForbidden = this.allRolesAllowed ? securityContext.getUserPrincipal() == null : this.allowedRoles.stream().noneMatch(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0));
        if (isForbidden) {
            RequestFailer.fail(requestContext);
        }
    }
}

