/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.Scheduled;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.util.AnnotationLiteral;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class SyntheticScheduled
extends AnnotationLiteral<Scheduled>
implements Scheduled {
    private static final long serialVersionUID = 1L;
    private final String identity;
    private final String cron;
    private final String every;
    private final long delay;
    private final TimeUnit delayUnit;
    private final String delayed;
    private final String overdueGracePeriod;
    private final Scheduled.ConcurrentExecution concurrentExecution;
    private final Scheduled.SkipPredicate skipPredicate;
    private final String timeZone;

    public SyntheticScheduled(String identity, String cron, String every, long delay, TimeUnit delayUnit, String delayed, String overdueGracePeriod, Scheduled.ConcurrentExecution concurrentExecution, Scheduled.SkipPredicate skipPredicate, String timeZone) {
        this.identity = Objects.requireNonNull(identity);
        this.cron = Objects.requireNonNull(cron);
        this.every = Objects.requireNonNull(every);
        this.delay = delay;
        this.delayUnit = Objects.requireNonNull(delayUnit);
        this.delayed = Objects.requireNonNull(delayed);
        this.overdueGracePeriod = Objects.requireNonNull(overdueGracePeriod);
        this.concurrentExecution = Objects.requireNonNull(concurrentExecution);
        this.skipPredicate = skipPredicate;
        this.timeZone = timeZone;
    }

    public String identity() {
        return this.identity;
    }

    public String cron() {
        return this.cron;
    }

    public String every() {
        return this.every;
    }

    public long delay() {
        return this.delay;
    }

    public TimeUnit delayUnit() {
        return this.delayUnit;
    }

    public String delayed() {
        return this.delayed;
    }

    public Scheduled.ConcurrentExecution concurrentExecution() {
        return this.concurrentExecution;
    }

    public Class<? extends Scheduled.SkipPredicate> skipExecutionIf() {
        return this.skipPredicate != null ? this.skipPredicate.getClass() : Scheduled.Never.class;
    }

    public String overdueGracePeriod() {
        return this.overdueGracePeriod;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public String toJson() {
        if (this.skipPredicate != null) {
            throw new IllegalStateException("A skipPredicate instance may not be serialized");
        }
        JsonObject json = new JsonObject();
        json.put("identity", (Object)this.identity);
        json.put("cron", (Object)this.cron);
        json.put("every", (Object)this.every);
        json.put("delay", (Object)this.delay);
        json.put("delayUnit", (Object)this.delayUnit.toString());
        json.put("delayed", (Object)this.delayed);
        json.put("overdueGracePeriod", (Object)this.overdueGracePeriod);
        json.put("concurrentExecution", (Object)this.concurrentExecution.toString());
        json.put("timeZone", (Object)this.timeZone);
        return json.encode();
    }

    public static SyntheticScheduled fromJson(String json) {
        JsonObject jsonObj = new JsonObject(json);
        return new SyntheticScheduled(jsonObj.getString("identity"), jsonObj.getString("cron"), jsonObj.getString("every"), jsonObj.getLong("delay"), TimeUnit.valueOf(jsonObj.getString("delayUnit")), jsonObj.getString("delayed"), jsonObj.getString("overdueGracePeriod"), Scheduled.ConcurrentExecution.valueOf((String)jsonObj.getString("concurrentExecution")), null, jsonObj.getString("timeZone"));
    }

    public String toString() {
        return "SyntheticScheduled [" + (String)(this.identity != null ? "identity=" + this.identity + ", " : "") + (String)(this.cron != null ? "cron=" + this.cron + ", " : "") + (String)(this.every != null ? "every=" + this.every : "") + "]";
    }
}

