/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.ScheduledMethodMetadata;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import io.quarkus.scheduler.runtime.SchedulerRecorder;
import io.quarkus.scheduler.runtime.SchedulerSupport;
import io.quarkus.scheduler.runtime.SimpleScheduler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SchedulerProcessor {
    private static final Logger LOGGER = Logger.getLogger(SchedulerProcessor.class);
    static final DotName SCHEDULED_NAME = DotName.createSimple((String)Scheduled.class.getName());
    static final DotName SCHEDULES_NAME = DotName.createSimple((String)Scheduled.Schedules.class.getName());
    static final Type SCHEDULED_EXECUTION_TYPE = Type.create((DotName)DotName.createSimple((String)ScheduledExecution.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String INVOKER_SUFFIX = "_ScheduledInvoker";

    @BuildStep
    AdditionalBeanBuildItem beans(Capabilities capabilities) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().addBeanClass(SchedulerSupport.class);
        if (!capabilities.isCapabilityPresent("io.quarkus.quartz")) {
            builder.addBeanClass(SimpleScheduler.class);
        }
        return builder.build();
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer(final CustomScopeAnnotationsBuildItem scopes) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.isClass() && !scopes.isScopeDeclaredOn(context.getTarget().asClass()) && (context.getTarget().asClass().annotations().containsKey(SCHEDULED_NAME) || context.getTarget().asClass().annotations().containsKey(SCHEDULES_NAME))) {
                    LOGGER.debugf("Found scheduled business methods on a class %s with no annotations - adding @Singleton", (Object)context.getTarget());
                    ((Transformation)context.transform().add(Singleton.class, new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void collectScheduledMethods(SchedulerConfig config, BeanArchiveIndexBuildItem beanArchives, ValidationPhaseBuildItem validationPhase, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : validationPhase.getContext().beans().classBeans()) {
            this.collectScheduledMethods(config, beanArchives.getIndex(), annotationStore, bean, ((AnnotationTarget)bean.getTarget().get()).asClass(), scheduledBusinessMethods, validationPhase.getContext());
        }
    }

    private void collectScheduledMethods(SchedulerConfig config, IndexView index, AnnotationStore annotationStore, BeanInfo bean, ClassInfo beanClass, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods, BeanDeploymentValidator.ValidationContext validationContext) {
        ClassInfo superClass;
        for (MethodInfo method : beanClass.methods()) {
            List<AnnotationInstance> schedules = null;
            AnnotationInstance scheduledAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULED_NAME);
            if (scheduledAnnotation != null) {
                schedules = Collections.singletonList(scheduledAnnotation);
            } else {
                AnnotationInstance scheduledsAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULES_NAME);
                if (scheduledsAnnotation != null) {
                    schedules = new ArrayList<AnnotationInstance>();
                    for (AnnotationInstance scheduledInstance : scheduledsAnnotation.value().asNestedArray()) {
                        schedules.add(scheduledInstance);
                    }
                }
            }
            if (schedules == null) continue;
            List params = method.parameters();
            if (params.size() > 1 || params.size() == 1 && !((Type)params.get(0)).equals((Object)SCHEDULED_EXECUTION_TYPE)) {
                validationContext.addDeploymentProblem((Throwable)new IllegalStateException(String.format("Invalid scheduled business method parameters %s [method: %s, bean: %s]", params, method, bean)));
                return;
            }
            if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                validationContext.addDeploymentProblem((Throwable)new IllegalStateException(String.format("Scheduled business method must return void [method: %s, bean: %s]", method, bean)));
                return;
            }
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)config.cronType));
            for (AnnotationInstance scheduled : schedules) {
                Throwable error = this.validateScheduled(parser, scheduled);
                if (error == null) continue;
                validationContext.addDeploymentProblem(error);
            }
            scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(bean, method, schedules));
            LOGGER.debugf("Found scheduled business method %s declared on %s", (Object)method, (Object)bean);
        }
        DotName superClassName = beanClass.superName();
        if (superClassName != null && (superClass = index.getClassByName(superClassName)) != null) {
            this.collectScheduledMethods(config, index, annotationStore, bean, superClass, scheduledBusinessMethods, validationContext);
        }
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> unremovableBeans() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULED_NAME)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULES_NAME)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void build(SchedulerConfig config, SchedulerRecorder recorder, BeanContainerBuildItem beanContainer, List<ScheduledBusinessMethodItem> scheduledBusinessMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<FeatureBuildItem> feature, BuildProducer<ServiceStartBuildItem> serviceStart, AnnotationProxyBuildItem annotationProxy, ExecutorBuildItem executor) {
        feature.produce((BuildItem)new FeatureBuildItem("scheduler"));
        ArrayList<ScheduledMethodMetadata> scheduledMethods = new ArrayList<ScheduledMethodMetadata>();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        for (ScheduledBusinessMethodItem businessMethod : scheduledBusinessMethods) {
            ScheduledMethodMetadata scheduledMethod = new ScheduledMethodMetadata();
            String invokerClass = this.generateInvoker(businessMethod.getBean(), businessMethod.getMethod(), (ClassOutput)classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{invokerClass}));
            scheduledMethod.setInvokerClassName(invokerClass);
            ArrayList<Object> schedules = new ArrayList<Object>();
            for (AnnotationInstance scheduled : businessMethod.getSchedules()) {
                schedules.add(annotationProxy.builder(scheduled, Scheduled.class).build((ClassOutput)classOutput));
            }
            scheduledMethod.setSchedules(schedules);
            scheduledMethod.setMethodDescription(businessMethod.getMethod().declaringClass() + "#" + businessMethod.getMethod().name());
            scheduledMethods.add(scheduledMethod);
        }
        recorder.initialize(config, scheduledMethods, executor.getExecutorProxy(), beanContainer.getValue());
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("scheduler"));
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((DotName)bean.getImplClazz().name()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{ScheduledInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invokeBean", Void.TYPE, new Class[]{Object.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class}), containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        if (method.parameters().isEmpty()) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[0]), beanInstanceHandle, new ResultHandle[0]);
        } else {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{ScheduledExecution.class}), beanInstanceHandle, new ResultHandle[]{invoke.getMethodParam(0)});
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private Throwable validateScheduled(CronParser parser, AnnotationInstance schedule) {
        AnnotationValue cronValue = schedule.value("cron");
        if (cronValue != null && !cronValue.asString().trim().isEmpty()) {
            String cron = cronValue.asString().trim();
            if (SchedulerSupport.isConfigValue((String)cron)) {
                return null;
            }
            try {
                parser.parse(cron).validate();
            }
            catch (IllegalArgumentException e) {
                return new IllegalStateException("Invalid cron() expression on: " + schedule, e);
            }
        } else {
            AnnotationValue everyValue = schedule.value("every");
            if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
                String every = everyValue.asString().trim();
                if (SchedulerSupport.isConfigValue((String)every)) {
                    return null;
                }
                if (Character.isDigit(every.charAt(0))) {
                    every = "PT" + every;
                }
                try {
                    Duration.parse(every);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid every() expression on: " + schedule, e);
                }
            } else {
                return new IllegalStateException("@Scheduled must declare either cron() or every(): " + schedule);
            }
        }
        return null;
    }
}

