/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.test.utils;

import io.quarkus.security.test.utils.AuthData;
import io.quarkus.security.test.utils.IdentityMock;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public class SecurityTestUtils {
    public static <T> void assertSuccess(Supplier<T> action, T expectedResult, AuthData ... auth) {
        for (AuthData authData : auth) {
            IdentityMock.setUpAuth(authData);
            Assertions.assertEquals(action.get(), expectedResult);
        }
    }

    public static void assertFailureFor(Executable action, Class<? extends Exception> expectedException, AuthData ... auth) {
        for (AuthData authData : auth) {
            IdentityMock.setUpAuth(authData);
            Assertions.assertThrows(expectedException, (Executable)action);
        }
    }

    private SecurityTestUtils() {
    }
}

