/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor.check;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.interceptor.check.SecurityCheck;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class RolesAllowedCheck
implements SecurityCheck {
    private static final Map<Collection<String>, RolesAllowedCheck> CACHE = new ConcurrentHashMap<Collection<String>, RolesAllowedCheck>();
    private final String[] allowedRoles;

    private RolesAllowedCheck(String[] allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    public static RolesAllowedCheck of(String[] allowedRoles) {
        return CACHE.computeIfAbsent(RolesAllowedCheck.getCollectionForKey(allowedRoles), new Function<Collection<String>, RolesAllowedCheck>(){

            @Override
            public RolesAllowedCheck apply(Collection<String> allowedRolesList) {
                return new RolesAllowedCheck(allowedRolesList.toArray(new String[0]));
            }
        });
    }

    private static Collection<String> getCollectionForKey(String[] allowedRoles) {
        if (allowedRoles.length == 0) {
            return Collections.emptyList();
        }
        if (allowedRoles.length == 1) {
            return Collections.singletonList(allowedRoles[0]);
        }
        return new HashSet<String>(Arrays.asList(allowedRoles));
    }

    @Override
    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        Set roles = identity.getRoles();
        if (roles != null) {
            for (String role : this.allowedRoles) {
                if (!roles.contains(role)) continue;
                return;
            }
        }
        if (identity.isAnonymous()) {
            throw new UnauthorizedException();
        }
        throw new ForbiddenException();
    }
}

