/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.runtime.QuarkusSecurityRolesAllowedConfigBuilder;
import io.quarkus.security.runtime.interceptor.SecurityCheckStorageBuilder;
import io.quarkus.security.runtime.interceptor.check.AuthenticatedCheck;
import io.quarkus.security.runtime.interceptor.check.DenyAllCheck;
import io.quarkus.security.runtime.interceptor.check.PermitAllCheck;
import io.quarkus.security.runtime.interceptor.check.RolesAllowedCheck;
import io.quarkus.security.runtime.interceptor.check.SupplierRolesAllowedCheck;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.smallrye.config.Expressions;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@Recorder
public class SecurityCheckRecorder {
    private static volatile SecurityCheckStorage storage;
    private static final Set<SupplierRolesAllowedCheck> configExpRolesAllowedChecks;

    public static SecurityCheckStorage getStorage() {
        return storage;
    }

    public SecurityCheck denyAll() {
        return DenyAllCheck.INSTANCE;
    }

    public SecurityCheck permitAll() {
        return PermitAllCheck.INSTANCE;
    }

    public SecurityCheck rolesAllowed(String ... roles) {
        return RolesAllowedCheck.of(roles);
    }

    public SecurityCheck rolesAllowedSupplier(String[] allowedRoles, int[] configExpIndexes, int[] configKeys) {
        for (int i = 0; i < configExpIndexes.length; ++i) {
            QuarkusSecurityRolesAllowedConfigBuilder.addProperty(configKeys[i], allowedRoles[configExpIndexes[i]]);
        }
        SupplierRolesAllowedCheck check = new SupplierRolesAllowedCheck(SecurityCheckRecorder.resolveRolesAllowedConfigExp(allowedRoles, configExpIndexes, configKeys));
        configExpRolesAllowedChecks.add(check);
        return check;
    }

    private static Supplier<String[]> resolveRolesAllowedConfigExp(String[] allowedRoles, final int[] configExpIndexes, final int[] configKeys) {
        final String[] roles = Arrays.copyOf(allowedRoles, allowedRoles.length);
        return new Supplier<String[]>(){

            @Override
            public String[] get() {
                Config config = ConfigProviderResolver.instance().getConfig(Thread.currentThread().getContextClassLoader());
                if (config.getOptionalValue("mp.config.property.expressions.enabled", Boolean.class).orElse(Boolean.TRUE).booleanValue() && Expressions.isEnabled()) {
                    for (int i = 0; i < configExpIndexes.length; ++i) {
                        roles[configExpIndexes[i]] = (String)config.getValue(QuarkusSecurityRolesAllowedConfigBuilder.transformToKey(configKeys[i]), String.class);
                    }
                }
                return roles;
            }
        };
    }

    public SecurityCheck authenticated() {
        return AuthenticatedCheck.INSTANCE;
    }

    public RuntimeValue<SecurityCheckStorageBuilder> newBuilder() {
        return new RuntimeValue((Object)new SecurityCheckStorageBuilder());
    }

    public void addMethod(RuntimeValue<SecurityCheckStorageBuilder> builder, String className, String methodName, String[] parameterTypes, SecurityCheck securityCheck) {
        ((SecurityCheckStorageBuilder)builder.getValue()).registerCheck(className, methodName, parameterTypes, securityCheck);
    }

    public void create(RuntimeValue<SecurityCheckStorageBuilder> builder) {
        storage = ((SecurityCheckStorageBuilder)builder.getValue()).create();
    }

    public void resolveRolesAllowedConfigExpRoles() {
        if (!configExpRolesAllowedChecks.isEmpty()) {
            for (SupplierRolesAllowedCheck configExpRolesAllowedCheck : configExpRolesAllowedChecks) {
                configExpRolesAllowedCheck.resolveAllowedRoles();
            }
            configExpRolesAllowedChecks.clear();
        }
    }

    static {
        configExpRolesAllowedChecks = ConcurrentHashMap.newKeySet();
    }
}

