/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime.interceptor.check;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.interceptor.check.RolesAllowedCheck;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class SupplierRolesAllowedCheck
implements SecurityCheck {
    private final Supplier<String[]> allowedRolesSupplier;
    private volatile String[] allowedRoles;

    public SupplierRolesAllowedCheck(Supplier<String[]> allowedRolesSupplier) {
        this.allowedRolesSupplier = allowedRolesSupplier;
    }

    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        this.doApply(identity);
    }

    public void apply(SecurityIdentity identity, MethodDescription methodDescription, Object[] parameters) {
        this.doApply(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doApply(SecurityIdentity identity) {
        if (this.allowedRoles == null) {
            SupplierRolesAllowedCheck supplierRolesAllowedCheck = this;
            synchronized (supplierRolesAllowedCheck) {
                if (this.allowedRoles == null) {
                    this.allowedRoles = this.allowedRolesSupplier.get();
                }
            }
        }
        RolesAllowedCheck.doApply(identity, this.allowedRoles);
    }
}

