/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.StringPermission;
import io.quarkus.security.runtime.QuarkusSecurityRolesAllowedConfigBuilder;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.runtime.interceptor.SecurityCheckStorageBuilder;
import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import io.quarkus.security.runtime.interceptor.check.AuthenticatedCheck;
import io.quarkus.security.runtime.interceptor.check.DenyAllCheck;
import io.quarkus.security.runtime.interceptor.check.PermissionSecurityCheck;
import io.quarkus.security.runtime.interceptor.check.PermitAllCheck;
import io.quarkus.security.runtime.interceptor.check.RolesAllowedCheck;
import io.quarkus.security.runtime.interceptor.check.SupplierRolesAllowedCheck;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.smallrye.config.Expressions;
import io.smallrye.config.common.utils.StringUtil;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@Recorder
public class SecurityCheckRecorder {
    private static volatile SecurityCheckStorage storage;
    private static final Set<SupplierRolesAllowedCheck> configExpRolesAllowedChecks;
    private static volatile boolean runtimeConfigReady;

    public static SecurityCheckStorage getStorage() {
        return storage;
    }

    public SecurityCheck denyAll() {
        return DenyAllCheck.INSTANCE;
    }

    public SecurityCheck permitAll() {
        return PermitAllCheck.INSTANCE;
    }

    public SecurityCheck rolesAllowed(String ... roles) {
        return RolesAllowedCheck.of(roles);
    }

    public SecurityCheck rolesAllowedSupplier(String[] allowedRoles, int[] configExpIndexes, int[] configKeys) {
        for (int i = 0; i < configExpIndexes.length; ++i) {
            QuarkusSecurityRolesAllowedConfigBuilder.addProperty(configKeys[i], allowedRoles[configExpIndexes[i]]);
        }
        SupplierRolesAllowedCheck check = new SupplierRolesAllowedCheck(SecurityCheckRecorder.resolveRolesAllowedConfigExp(allowedRoles, configExpIndexes, configKeys));
        configExpRolesAllowedChecks.add(check);
        return check;
    }

    public void recordRolesAllowedConfigExpression(String configExpression, int configKeyIndex, BiConsumer<String, Supplier<String[]>> configValueRecorder) {
        QuarkusSecurityRolesAllowedConfigBuilder.addProperty(configKeyIndex, configExpression);
        Supplier<String[]> configValSupplier = SecurityCheckRecorder.resolveRolesAllowedConfigExp(new String[]{configExpression}, new int[]{0}, new int[]{configKeyIndex});
        configValueRecorder.accept(configExpression, configValSupplier);
    }

    private static Supplier<String[]> resolveRolesAllowedConfigExp(String[] allowedRoles, final int[] configExpIndexes, final int[] configKeys) {
        final ArrayList<String> roles = new ArrayList<String>(Arrays.asList(allowedRoles));
        return new Supplier<String[]>(){

            @Override
            public String[] get() {
                Config config = ConfigProviderResolver.instance().getConfig(Thread.currentThread().getContextClassLoader());
                if (config.getOptionalValue("mp.config.property.expressions.enabled", Boolean.class).orElse(Boolean.TRUE).booleanValue() && Expressions.isEnabled()) {
                    for (int i = 0; i < configExpIndexes.length; ++i) {
                        String[] strArr;
                        String strVal = (String)config.getValue(QuarkusSecurityRolesAllowedConfigBuilder.transformToKey(configKeys[i]), String.class);
                        if (strVal != null && strVal.contains(",") && (strArr = StringUtil.split((String)strVal)).length >= 1) {
                            strVal = strArr[0];
                            if (strArr.length > 1) {
                                for (int i1 = 1; i1 < strArr.length; ++i1) {
                                    roles.add(strArr[i1]);
                                }
                            }
                        }
                        roles.set(configExpIndexes[i], strVal);
                    }
                }
                return (String[])roles.toArray(String[]::new);
            }
        };
    }

    public SecurityCheck authenticated() {
        return AuthenticatedCheck.INSTANCE;
    }

    public SecurityCheck permissionsAllowed(Function<Object[], Permission> computedPermission, RuntimeValue<Permission> permissionRuntimeValue) {
        Permission permission;
        if (computedPermission == null) {
            Objects.requireNonNull(permissionRuntimeValue);
            permission = (Permission)permissionRuntimeValue.getValue();
        } else {
            permission = null;
        }
        return PermissionSecurityCheck.of(permission, computedPermission);
    }

    public SecurityCheck permissionsAllowed(final List<Function<Object[], Permission>> computedPermissions, List<RuntimeValue<Permission>> permissionsRuntimeValue) {
        Permission[] permissions;
        Function<Object[], Permission[]> computedPermissionsAggregator;
        if (computedPermissions == null) {
            Objects.requireNonNull(permissionsRuntimeValue);
            computedPermissionsAggregator = null;
            permissions = new Permission[permissionsRuntimeValue.size()];
            for (int i = 0; i < permissionsRuntimeValue.size(); ++i) {
                permissions[i] = Objects.requireNonNull((Permission)permissionsRuntimeValue.get(i).getValue());
            }
        } else {
            permissions = null;
            computedPermissionsAggregator = new Function<Object[], Permission[]>(){

                @Override
                public Permission[] apply(Object[] securedMethodParameters) {
                    Permission[] result = new Permission[computedPermissions.size()];
                    for (int i = 0; i < computedPermissions.size(); ++i) {
                        result[i] = (Permission)((Function)computedPermissions.get(i)).apply(securedMethodParameters);
                    }
                    return result;
                }
            };
        }
        return PermissionSecurityCheck.of(permissions, computedPermissionsAggregator);
    }

    public SecurityCheck permissionsAllowedGroups(final List<List<Function<Object[], Permission>>> computedPermissionGroups, List<List<RuntimeValue<Permission>>> permissionGroupsRuntimeValue) {
        Permission[][] permissionGroups;
        Function<Object[], Permission[][]> computedPermissionGroupAggregator;
        if (computedPermissionGroups == null) {
            Objects.requireNonNull(permissionGroupsRuntimeValue);
            computedPermissionGroupAggregator = null;
            permissionGroups = new Permission[permissionGroupsRuntimeValue.size()][];
            for (int i = 0; i < permissionGroupsRuntimeValue.size(); ++i) {
                List<RuntimeValue<Permission>> groupRuntimeValue = permissionGroupsRuntimeValue.get(i);
                permissionGroups[i] = new Permission[groupRuntimeValue.size()];
                for (int j = 0; j < groupRuntimeValue.size(); ++j) {
                    permissionGroups[i][j] = (Permission)groupRuntimeValue.get(j).getValue();
                }
            }
        } else {
            permissionGroups = null;
            computedPermissionGroupAggregator = new Function<Object[], Permission[][]>(){

                @Override
                public Permission[][] apply(Object[] securedMethodParams) {
                    Permission[][] permissionGroups = new Permission[computedPermissionGroups.size()][];
                    for (int i = 0; i < computedPermissionGroups.size(); ++i) {
                        List computedPermissionGroup = (List)computedPermissionGroups.get(i);
                        permissionGroups[i] = new Permission[computedPermissionGroup.size()];
                        for (int j = 0; j < computedPermissionGroup.size(); ++j) {
                            permissionGroups[i][j] = (Permission)((Function)computedPermissionGroup.get(j)).apply(securedMethodParams);
                        }
                    }
                    return permissionGroups;
                }
            };
        }
        return PermissionSecurityCheck.of(permissionGroups, computedPermissionGroupAggregator);
    }

    public Function<Object[], Permission> toComputedPermission(final RuntimeValue<Permission> permissionRuntimeVal) {
        return new Function<Object[], Permission>(){

            @Override
            public Permission apply(Object[] objects) {
                return (Permission)permissionRuntimeVal.getValue();
            }
        };
    }

    public RuntimeValue<Permission> createStringPermission(String name, String[] actions) {
        return new RuntimeValue((Object)new StringPermission(name, actions));
    }

    public RuntimeValue<Permission> createPermission(String name, String clazz, String[] actions, boolean passActionsToConstructor) {
        Permission permission;
        try {
            permission = passActionsToConstructor ? (Permission)this.loadClass(clazz).getConstructors()[0].newInstance(name, actions) : (Permission)this.loadClass(clazz).getConstructors()[0].newInstance(name);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Failed to create Permission - class '%s', name '%s', actions '%s'", clazz, name, Arrays.toString(actions)), e);
        }
        return new RuntimeValue((Object)permission);
    }

    public Function<Object[], Permission> createComputedPermission(final String permissionName, final String clazz, final String[] actions, final boolean passActionsToConstructor, final int[] formalParamIndexes) {
        int addActions = passActionsToConstructor ? 1 : 0;
        final int argsCount = 1 + addActions + formalParamIndexes.length;
        final int methodArgsStart = 1 + addActions;
        final Constructor<?> permissionClassConstructor = this.loadClass(clazz).getConstructors()[0];
        return new Function<Object[], Permission>(){

            @Override
            public Permission apply(Object[] securedMethodArgs) {
                try {
                    Object[] initArgs = this.initArgs(securedMethodArgs);
                    return (Permission)permissionClassConstructor.newInstance(initArgs);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(String.format("Failed to create computed Permission - class '%s', name '%s', actions '%s', ", clazz, permissionName, Arrays.toString(actions)), e);
                }
            }

            private Object[] initArgs(Object[] methodArgs) {
                Object[] initArgs = new Object[argsCount];
                initArgs[0] = permissionName;
                if (passActionsToConstructor) {
                    initArgs[1] = actions;
                }
                for (int i = 0; i < formalParamIndexes.length; ++i) {
                    initArgs[methodArgsStart + i] = methodArgs[formalParamIndexes[i]];
                }
                return initArgs;
            }
        };
    }

    public RuntimeValue<SecurityCheckStorageBuilder> newBuilder() {
        return new RuntimeValue((Object)new SecurityCheckStorageBuilder());
    }

    public void addMethod(RuntimeValue<SecurityCheckStorageBuilder> builder, String className, String methodName, String[] parameterTypes, SecurityCheck securityCheck) {
        ((SecurityCheckStorageBuilder)builder.getValue()).registerCheck(className, methodName, parameterTypes, securityCheck);
    }

    public void create(RuntimeValue<SecurityCheckStorageBuilder> builder) {
        storage = ((SecurityCheckStorageBuilder)builder.getValue()).create();
    }

    public void resolveRolesAllowedConfigExpRoles() {
        if (!configExpRolesAllowedChecks.isEmpty()) {
            for (SupplierRolesAllowedCheck configExpRolesAllowedCheck : configExpRolesAllowedChecks) {
                configExpRolesAllowedCheck.resolveAllowedRoles();
            }
            configExpRolesAllowedChecks.clear();
        }
    }

    private Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class '" + className + "' for creating permission", e);
        }
    }

    public void registerDefaultSecurityCheck(RuntimeValue<SecurityCheckStorageBuilder> builder, SecurityCheck securityCheck) {
        ((SecurityCheckStorageBuilder)builder.getValue()).registerDefaultSecurityCheck(securityCheck);
    }

    public Supplier<SecurityConstrainer> createSecurityConstrainer(final Supplier<Map<String, Object>> additionalEventPropsSupplier) {
        return new Supplier<SecurityConstrainer>(){

            @Override
            public SecurityConstrainer get() {
                ArcContainer container = Arc.container();
                BeanManager beanManager = container.beanManager();
                Supplier<Map<String, Object>> eventPropsSupplier = additionalEventPropsSupplier == null ? new Supplier<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> get() {
                        return Map.of();
                    }
                } : additionalEventPropsSupplier;
                return new SecurityConstrainer((SecurityCheckStorage)container.instance(SecurityCheckStorage.class, new Annotation[0]).get(), beanManager, (Event<AuthorizationFailureEvent>)beanManager.getEvent().select(AuthorizationFailureEvent.class, new Annotation[0]), (Event<AuthorizationSuccessEvent>)beanManager.getEvent().select(AuthorizationSuccessEvent.class, new Annotation[0]), runtimeConfigReady, (Instance<SecurityIdentityAssociation>)container.select(SecurityIdentityAssociation.class, new Annotation[0]), eventPropsSupplier);
            }
        };
    }

    public void setRuntimeConfigReady() {
        runtimeConfigReady = true;
    }

    public void unsetRuntimeConfigReady(ShutdownContext shutdownContext) {
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                runtimeConfigReady = false;
            }
        });
    }

    static {
        configExpRolesAllowedChecks = ConcurrentHashMap.newKeySet();
        runtimeConfigReady = false;
    }
}

