/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class QuarkusSecurityIdentity
implements SecurityIdentity {
    private final Principal principal;
    private final Set<String> roles;
    private final Set<Credential> credentials;
    private final Map<String, Object> attributes;
    private final List<Function<Permission, Uni<Boolean>>> permissionCheckers;
    private final boolean anonymous;

    private QuarkusSecurityIdentity(Builder builder) {
        this.principal = builder.principal;
        this.roles = Collections.unmodifiableSet(builder.roles);
        this.credentials = Collections.unmodifiableSet(builder.credentials);
        this.attributes = Collections.unmodifiableMap(builder.attributes);
        this.permissionCheckers = Collections.unmodifiableList(builder.permissionCheckers);
        this.anonymous = builder.anonymous;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        return this.roles.contains(role);
    }

    public <T extends Credential> T getCredential(Class<T> credentialType) {
        for (Credential i : this.credentials) {
            if (!credentialType.isAssignableFrom(i.getClass())) continue;
            return (T)i;
        }
        return null;
    }

    public Set<Credential> getCredentials() {
        return this.credentials;
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Uni<Boolean> checkPermission(Permission permission) {
        if (this.permissionCheckers.isEmpty()) {
            return Uni.createFrom().item((Object)false);
        }
        ArrayList<Uni<Boolean>> results = new ArrayList<Uni<Boolean>>(this.permissionCheckers.size());
        for (Function<Permission, Uni<Boolean>> checker : this.permissionCheckers) {
            Uni<Boolean> res = checker.apply(permission);
            if (res == null) continue;
            results.add(res);
        }
        if (results.isEmpty()) {
            return Uni.createFrom().item((Object)false);
        }
        if (results.size() == 1) {
            return (Uni)results.get(0);
        }
        return Uni.combine().all().unis(results).combinedWith(new Function<List<?>, Boolean>(){

            @Override
            public Boolean apply(List<?> o) {
                Boolean result = null;
                for (Object i : o) {
                    if (i == null) continue;
                    boolean val = (Boolean)i;
                    if (val) {
                        return true;
                    }
                    result = false;
                }
                return result;
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(final SecurityIdentity identity) {
        Builder builder = new Builder().addAttributes(identity.getAttributes()).addCredentials(identity.getCredentials()).addRoles(identity.getRoles()).addPermissionChecker(new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission permission) {
                return identity.checkPermission(permission);
            }
        }).setPrincipal(identity.getPrincipal()).setAnonymous(identity.isAnonymous());
        return builder;
    }

    public static class Builder {
        Principal principal;
        Set<String> roles = new HashSet<String>();
        Set<Credential> credentials = new HashSet<Credential>();
        Map<String, Object> attributes = new HashMap<String, Object>();
        List<Function<Permission, Uni<Boolean>>> permissionCheckers = new ArrayList<Function<Permission, Uni<Boolean>>>();
        private boolean anonymous;
        boolean built = false;

        public Builder setPrincipal(Principal principal) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.principal = principal;
            return this;
        }

        public Builder addRole(String role) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.roles.add(role);
            return this;
        }

        public Builder addRoles(Set<String> roles) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.roles.addAll(roles);
            return this;
        }

        public Builder addCredential(Credential credential) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.credentials.add(credential);
            return this;
        }

        public Builder addCredentials(Set<Credential> credentials) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.credentials.addAll(credentials);
            return this;
        }

        public Builder addAttribute(String key, Object value) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder addAttributes(Map<String, Object> attributes) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder addPermissionChecker(Function<Permission, Uni<Boolean>> function) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.permissionCheckers.add(function);
            return this;
        }

        public Builder addPermissionCheckers(List<Function<Permission, Uni<Boolean>>> functions) {
            if (this.built) {
                throw new IllegalStateException();
            }
            if (functions != null) {
                this.permissionCheckers.addAll(functions);
            }
            return this;
        }

        public Builder setAnonymous(boolean anonymous) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.anonymous = anonymous;
            return this;
        }

        public QuarkusSecurityIdentity build() {
            if (this.principal == null && !this.anonymous) {
                throw new IllegalStateException("Principal is null but anonymous status is false");
            }
            this.built = true;
            return new QuarkusSecurityIdentity(this);
        }
    }
}

