/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.runtime;

import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.metrics.MetricRegistries;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class QuarkusJaxRsMetricsFilter
implements ContainerRequestFilter {
    @Context
    ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        Long start = System.nanoTime();
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        RoutingContext routingContext = ((CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get()).getCurrent();
        routingContext.addBodyEndHandler(event -> this.finishRequest(start, resourceClass, resourceMethod));
    }

    private void finishRequest(Long start, Class<?> resourceClass, Method resourceMethod) {
        long value = System.nanoTime() - start;
        MetricID metricID = this.getMetricID(resourceClass, resourceMethod);
        MetricRegistry registry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE);
        if (!registry.getMetadata().containsKey(metricID.getName())) {
            Metadata metadata = Metadata.builder().withName(metricID.getName()).withDescription("The number of invocations and total response time of this RESTful resource method since the start of the server.").withUnit("nanoseconds").build();
            registry.simpleTimer(metadata, metricID.getTagsAsArray());
        }
        registry.simpleTimer(metricID.getName(), metricID.getTagsAsArray()).update(Duration.ofNanos(value));
    }

    private MetricID getMetricID(Class<?> resourceClass, Method resourceMethod) {
        Tag classTag = new Tag("class", resourceClass.getName());
        String methodName = resourceMethod.getName();
        StringBuilder sb = new StringBuilder();
        for (Class<?> parameterType : resourceMethod.getParameterTypes()) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            if (parameterType.isArray()) {
                sb.append(parameterType.getComponentType().getName()).append("[]");
                continue;
            }
            sb.append(parameterType.getName());
        }
        String encodedParameterNames = sb.toString();
        String methodTagValue = encodedParameterNames.isEmpty() ? methodName : methodName + "_" + encodedParameterNames;
        Tag methodTag = new Tag("method", methodTagValue);
        return new MetricID("REST.request", new Tag[]{classTag, methodTag});
    }
}

