/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.opentracing.runtime;

import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.OperationNameProvider;
import io.opentracing.contrib.jaxrs2.server.ServerTracingDynamicFeature;
import io.smallrye.opentracing.SmallRyeTracingDynamicFeature;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Provider
public class QuarkusSmallRyeTracingDynamicFeature
implements DynamicFeature {
    private static final Logger logger = Logger.getLogger((String)SmallRyeTracingDynamicFeature.class.getName());
    private final ServerTracingDynamicFeature delegate;

    public QuarkusSmallRyeTracingDynamicFeature() {
        Config config = ConfigProvider.getConfig();
        Optional skipPattern = config.getOptionalValue("mp.opentracing.server.skip-pattern", String.class);
        Optional operationNameProvider = config.getOptionalValue("mp.opentracing.server.operation-name-provider", String.class);
        ServerTracingDynamicFeature.Builder builder = new ServerTracingDynamicFeature.Builder((Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get()).withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.ClassNameOperationName.newBuilder()).withTraceSerialization(false);
        if (skipPattern.isPresent()) {
            builder.withSkipPattern((String)skipPattern.get());
        }
        if (operationNameProvider.isPresent()) {
            if ("http-path".equalsIgnoreCase((String)operationNameProvider.get())) {
                builder.withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.WildcardOperationName.newBuilder());
            } else if (!"class-method".equalsIgnoreCase((String)operationNameProvider.get())) {
                logger.warn((Object)"Provided operation name does not match http-path or class-method. Using default class-method.");
            }
        }
        this.delegate = builder.build();
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        this.delegate.configure(resourceInfo, context);
    }
}

