/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.ChannelBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.EmitterBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.MediatorBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.QuarkusMediatorConfigurationUtil;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingBuildTimeConfig;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusMediatorConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusWorkerPoolRegistry;
import io.quarkus.smallrye.reactivemessaging.runtime.ReactiveMessagingConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingLifecycle;
import io.quarkus.smallrye.reactivemessaging.runtime.SmallRyeReactiveMessagingRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.WorkerConfiguration;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.extension.ChannelConfiguration;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.health.SmallRyeReactiveMessagingLivenessCheck;
import io.smallrye.reactive.messaging.health.SmallRyeReactiveMessagingReadinessCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SmallRyeReactiveMessagingProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.smallrye-reactive-messaging.deployment.processor");
    static final String INVOKER_SUFFIX = "_SmallRyeMessagingInvoker";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SMALLRYE_REACTIVE_MESSAGING);
    }

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{SmallRyeReactiveMessagingLifecycle.class, Connector.class, Channel.class, io.smallrye.reactive.messaging.annotations.Channel.class, QuarkusWorkerPoolRegistry.class});
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformBeanScope(BeanArchiveIndexBuildItem index, final CustomScopeAnnotationsBuildItem scopes) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (ctx.isClass()) {
                    ClassInfo clazz = ctx.getTarget().asClass();
                    Map annotations = clazz.annotations();
                    if (scopes.isScopeDeclaredOn(clazz) || annotations.containsKey(ReactiveMessagingDotNames.JAXRS_PATH) || annotations.containsKey(ReactiveMessagingDotNames.REST_CONTROLLER) || annotations.containsKey(ReactiveMessagingDotNames.JAXRS_PROVIDER)) {
                        return;
                    }
                    if (annotations.containsKey(ReactiveMessagingDotNames.INCOMING) || annotations.containsKey(ReactiveMessagingDotNames.OUTGOING)) {
                        LOGGER.debugf("Found reactive messaging annotations on a class %s with no scope defined - adding @Dependent", (Object)ctx.getTarget());
                        ((Transformation)ctx.transform().add(Dependent.class, new AnnotationValue[0])).done();
                    }
                }
            }
        });
    }

    @BuildStep
    void collectComponents(BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<MediatorBuildItem> mediatorMethods, BuildProducer<EmitterBuildItem> emitters, BuildProducer<ChannelBuildItem> channels, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance incoming = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.INCOMING);
                AnnotationInstance incomings = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.INCOMINGS);
                AnnotationInstance outgoing = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.OUTGOING);
                AnnotationInstance blocking = transformedAnnotations.getAnnotation((AnnotationTarget)method, ReactiveMessagingDotNames.BLOCKING);
                if (incoming != null || incomings != null || outgoing != null) {
                    if (incoming != null && incoming.value().asString().isEmpty()) {
                        validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Empty @Incoming annotation on method " + method)}));
                    }
                    if (outgoing != null && outgoing.value().asString().isEmpty()) {
                        validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Empty @Outgoing annotation on method " + method)}));
                    }
                    mediatorMethods.produce((BuildItem)new MediatorBuildItem(bean, method));
                    LOGGER.debugf("Found mediator business method %s declared on %s", (Object)method, (Object)bean);
                    continue;
                }
                if (blocking == null) continue;
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("@Blocking used on " + method + " which has no @Incoming or @Outgoing annotation")}));
            }
        }
        for (InjectionPointInfo injectionPoint : beanDiscoveryFinished.getInjectionPoints()) {
            String name;
            Optional<AnnotationInstance> overflow;
            String channelName;
            Optional<AnnotationInstance> broadcast = this.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.BROADCAST);
            Optional<AnnotationInstance> channel = this.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.CHANNEL);
            Optional<AnnotationInstance> legacyChannel = this.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.LEGACY_CHANNEL);
            boolean isEmitter = injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.EMITTER);
            boolean isMutinyEmitter = injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.MUTINY_EMITTER);
            boolean isLegacyEmitter = injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.LEGACY_EMITTER);
            if (isEmitter || isMutinyEmitter) {
                if (!channel.isPresent()) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Invalid emitter injection - @Channel is required for " + injectionPoint.getTargetInfo())}));
                } else {
                    channelName = channel.get().value().asString();
                    overflow = this.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.ON_OVERFLOW);
                    this.createEmitter(emitters, injectionPoint, channelName, overflow, broadcast);
                }
            }
            if (isLegacyEmitter) {
                if (!legacyChannel.isPresent()) {
                    validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new DeploymentException("Invalid emitter injection - @Channel is required for " + injectionPoint.getTargetInfo())}));
                } else {
                    channelName = legacyChannel.get().value().asString();
                    overflow = this.getAnnotation(transformedAnnotations, injectionPoint, ReactiveMessagingDotNames.LEGACY_ON_OVERFLOW);
                    this.createEmitter(emitters, injectionPoint, channelName, overflow, broadcast);
                }
            }
            if (channel.isPresent() && !isEmitter && !isMutinyEmitter && (name = channel.get().value().asString()) != null && !name.trim().isEmpty()) {
                channels.produce((BuildItem)ChannelBuildItem.of(name));
            }
            if (!legacyChannel.isPresent() || isLegacyEmitter || (name = legacyChannel.get().value().asString()) == null || name.trim().isEmpty()) continue;
            channels.produce((BuildItem)ChannelBuildItem.of(name));
        }
    }

    private Optional<AnnotationInstance> getAnnotation(TransformedAnnotationsBuildItem transformedAnnotations, InjectionPointInfo injectionPoint, DotName annotationName) {
        Collection annotations = transformedAnnotations.getAnnotations(injectionPoint.getTarget());
        for (AnnotationInstance annotation : annotations) {
            if (!annotationName.equals((Object)annotation.name())) continue;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER && injectionPoint.isParam() && annotation.target().asMethodParameter().position() == injectionPoint.getPosition()) {
                return Optional.of(annotation);
            }
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    private void createEmitter(BuildProducer<EmitterBuildItem> emitters, InjectionPointInfo injectionPoint, String channelName, Optional<AnnotationInstance> overflow, Optional<AnnotationInstance> broadcast) {
        LOGGER.debugf("Emitter injection point '%s' detected, channel name: '%s'", (Object)injectionPoint.getTargetInfo(), (Object)channelName);
        boolean hasBroadcast = false;
        int awaitSubscribers = -1;
        int bufferSize = -1;
        String strategy = null;
        if (broadcast.isPresent()) {
            hasBroadcast = true;
            AnnotationValue value = broadcast.get().value();
            int n = awaitSubscribers = value == null ? 0 : value.asInt();
        }
        if (overflow.isPresent()) {
            AnnotationInstance annotation = overflow.get();
            AnnotationValue maybeBufferSize = annotation.value("bufferSize");
            bufferSize = maybeBufferSize == null ? 0 : maybeBufferSize.asInt();
            strategy = annotation.value().asString();
        }
        boolean isMutinyEmitter = injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.MUTINY_EMITTER);
        emitters.produce((BuildItem)EmitterBuildItem.of(channelName, isMutinyEmitter, strategy, bufferSize, hasBroadcast, awaitSubscribers));
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> removalExclusions() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.INCOMING)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ReactiveMessagingDotNames.OUTGOING)));
    }

    @BuildStep
    public void enableMetrics(BuildProducer<AnnotationsTransformerBuildItem> transformers, Optional<MetricsCapabilityBuildItem> metricsCapability, ReactiveMessagingConfiguration configuration) {
        boolean useMicrometer;
        boolean isMetricEnabled = metricsCapability.isPresent() && configuration.metricsEnabled;
        boolean bl = useMicrometer = isMetricEnabled && metricsCapability.get().metricsSupported("micrometer");
        if (!isMetricEnabled || useMicrometer) {
            LOGGER.debug((Object)("Metrics Enabled: " + isMetricEnabled + "; Using Micrometer: " + useMicrometer));
            AnnotationsTransformerBuildItem veto = new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

                public boolean appliesTo(AnnotationTarget.Kind kind) {
                    return kind == AnnotationTarget.Kind.CLASS;
                }

                public void transform(AnnotationsTransformer.TransformationContext ctx) {
                    if (ctx.getTarget().asClass().name().equals((Object)ReactiveMessagingDotNames.METRIC_DECORATOR)) {
                        ((Transformation)((Transformation)ctx.transform().removeAll()).add(Vetoed.class, new AnnotationValue[0])).done();
                    }
                }
            });
            transformers.produce((BuildItem)veto);
        }
    }

    @BuildStep
    public void enableHealth(ReactiveMessagingBuildTimeConfig buildTimeConfig, BuildProducer<HealthBuildItem> producer) {
        producer.produce((BuildItem)new HealthBuildItem(SmallRyeReactiveMessagingLivenessCheck.class.getName(), buildTimeConfig.healthEnabled));
        producer.produce((BuildItem)new HealthBuildItem(SmallRyeReactiveMessagingReadinessCheck.class.getName(), buildTimeConfig.healthEnabled));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(SmallRyeReactiveMessagingRecorder recorder, RecorderContext recorderContext, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, List<MediatorBuildItem> mediatorMethods, List<EmitterBuildItem> emitterFields, List<ChannelBuildItem> channelFields, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, ReactiveMessagingConfiguration conf) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        ArrayList<QuarkusMediatorConfiguration> mediatorConfigurations = new ArrayList<QuarkusMediatorConfiguration>(mediatorMethods.size());
        ArrayList<WorkerConfiguration> workerConfigurations = new ArrayList<WorkerConfiguration>();
        ArrayList<EmitterConfiguration> emittersConfiguratons = new ArrayList<EmitterConfiguration>();
        ArrayList<ChannelConfiguration> channelConfigurations = new ArrayList<ChannelConfiguration>();
        for (MediatorBuildItem mediatorBuildItem : mediatorMethods) {
            MethodInfo methodInfo = mediatorBuildItem.getMethod();
            BeanInfo bean = mediatorBuildItem.getBean();
            String generatedInvokerName = this.generateInvoker(bean, methodInfo, (ClassOutput)classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{generatedInvokerName}));
            if (methodInfo.hasAnnotation(ReactiveMessagingDotNames.BLOCKING) || methodInfo.hasAnnotation(ReactiveMessagingDotNames.SMALLRYE_BLOCKING)) {
                String poolName = "<no-value>";
                if (methodInfo.hasAnnotation(ReactiveMessagingDotNames.BLOCKING)) {
                    AnnotationInstance blocking = methodInfo.annotation(ReactiveMessagingDotNames.BLOCKING);
                    poolName = blocking.value() == null ? "<no-value>" : blocking.value().asString();
                }
                workerConfigurations.add(new WorkerConfiguration(methodInfo.declaringClass().toString(), methodInfo.name(), poolName));
            }
            try {
                QuarkusMediatorConfiguration mediatorConfiguration = QuarkusMediatorConfigurationUtil.create(methodInfo, bean, generatedInvokerName, recorderContext, Thread.currentThread().getContextClassLoader());
                mediatorConfigurations.add(mediatorConfiguration);
            }
            catch (IllegalArgumentException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        for (EmitterBuildItem emitterBuildItem : emitterFields) {
            emittersConfiguratons.add(emitterBuildItem.getEmitterConfig());
        }
        for (ChannelBuildItem channelBuildItem : channelFields) {
            channelConfigurations.add(channelBuildItem.getChannelConfig());
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(SmallRyeReactiveMessagingRecorder.SmallRyeReactiveMessagingContext.class).supplier(recorder.createContext(mediatorConfigurations, workerConfigurations, emittersConfiguratons, channelConfigurations)).done());
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((DotName)bean.getImplClazz().name()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String targetPackage = DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name());
        String generatedName = targetPackage + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        try (ClassCreator invoker = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{Invoker.class}).build();){
            String beanInstanceType = method.declaringClass().name().toString();
            FieldDescriptor beanInstanceField = invoker.getFieldCreator("beanInstance", beanInstanceType).getFieldDescriptor();
            try (MethodCreator ctor = invoker.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
                ctor.setModifiers(1);
                ctor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), ctor.getThis(), new ResultHandle[0]);
                ResultHandle self = ctor.getThis();
                ResultHandle beanInstance = ctor.getMethodParam(0);
                ctor.writeInstanceField(beanInstanceField, self, beanInstance);
                ctor.returnValue(null);
            }
            var13_15 = null;
            try (MethodCreator invoke = invoker.getMethodCreator(MethodDescriptor.ofMethod((Object)generatedName, (String)"invoke", Object.class, (Object[])new Object[]{Object[].class}));){
                int parametersCount = method.parameters().size();
                String[] argTypes = new String[parametersCount];
                ResultHandle[] args = new ResultHandle[parametersCount];
                for (int i = 0; i < parametersCount; ++i) {
                    args[i] = invoke.readArrayValue(invoke.getMethodParam(0), i);
                    argTypes[i] = ((Type)method.parameters().get(i)).name().toString();
                }
                ResultHandle result = invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((String)beanInstanceType, (String)method.name(), (String)method.returnType().name().toString(), (String[])argTypes), invoke.readInstanceField(beanInstanceField, invoke.getThis()), args);
                if (ReactiveMessagingDotNames.VOID.equals((Object)method.returnType().name())) {
                    invoke.returnValue(invoke.loadNull());
                } else {
                    invoke.returnValue(result);
                }
            }
            catch (Throwable throwable) {
                var13_15 = throwable;
                throw throwable;
            }
        }
        return generatedName.replace('/', '.');
    }
}

