/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment.devconsole;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.runtime.devconsole.Connectors;
import io.quarkus.smallrye.reactivemessaging.runtime.devconsole.DevConsoleRecorder;
import io.quarkus.smallrye.reactivemessaging.runtime.devconsole.DevReactiveMessagingInfosSupplier;
import java.util.HashMap;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;

public class DevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRuntimeTemplateInfoBuildItem collectInfos() {
        return new DevConsoleRuntimeTemplateInfoBuildItem("reactiveMessagingInfos", (Supplier)new DevReactiveMessagingInfosSupplier());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    public void collectInjectionInfo(DevConsoleRecorder recorder, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished) {
        HashMap<String, String> emitters = new HashMap<String, String>();
        HashMap<String, String> channels = new HashMap<String, String>();
        for (InjectionPointInfo injectionPoint : beanDiscoveryFinished.getInjectionPoints()) {
            boolean isEmitter;
            AnnotationInstance channelAnnotation = injectionPoint.getRequiredQualifier(ReactiveMessagingDotNames.CHANNEL);
            if (channelAnnotation == null) {
                channelAnnotation = injectionPoint.getRequiredQualifier(ReactiveMessagingDotNames.LEGACY_CHANNEL);
            }
            boolean bl = isEmitter = injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.EMITTER) || injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.MUTINY_EMITTER) || injectionPoint.getRequiredType().name().equals((Object)ReactiveMessagingDotNames.LEGACY_EMITTER);
            if (channelAnnotation == null) continue;
            if (isEmitter) {
                emitters.put(channelAnnotation.value().asString(), injectionPoint.getTargetInfo());
                continue;
            }
            channels.put(channelAnnotation.value().asString(), injectionPoint.getTargetInfo());
        }
        recorder.setInjectionInfo(emitters, channels);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    AdditionalBeanBuildItem beans() {
        return AdditionalBeanBuildItem.unremovableOf(Connectors.class);
    }
}

