/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.cloud.config.client.runtime;

import io.quarkus.runtime.util.StringUtil;
import io.quarkus.spring.cloud.config.client.runtime.Response;
import io.quarkus.spring.cloud.config.client.runtime.SpringCloudConfigClientConfig;
import io.quarkus.spring.cloud.config.client.runtime.VertxSpringCloudConfigGateway;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.common.MapBackedConfigSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class SpringCloudConfigClientConfigSourceFactory
implements ConfigSourceFactory.ConfigurableConfigSourceFactory<SpringCloudConfigClientConfig> {
    private static final Logger log = Logger.getLogger(SpringCloudConfigClientConfigSourceFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context, SpringCloudConfigClientConfig config) {
        boolean inAppCDsGeneration = Boolean.parseBoolean(System.getProperty("quarkus.appcds.generate", "false"));
        if (inAppCDsGeneration) {
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
        if (!config.enabled()) {
            log.debug((Object)"No attempt will be made to obtain configuration from the Spring Cloud Config Server because the functionality has been disabled via configuration");
            return sources;
        }
        String applicationName = config.name();
        if (StringUtil.isNullOrEmpty((String)applicationName)) {
            log.warn((Object)"No attempt will be made to obtain configuration from the Spring Cloud Config Server because the application name has not been set. Consider setting it via 'quarkus.spring-cloud-config.name'");
            return sources;
        }
        boolean connectionTimeoutIsGreaterThanZero = !config.connectionTimeout().isNegative() && !config.connectionTimeout().isZero();
        boolean readTimeoutIsGreaterThanZero = !config.readTimeout().isNegative() && !config.readTimeout().isZero();
        try (VertxSpringCloudConfigGateway client = new VertxSpringCloudConfigGateway(config);){
            ArrayList<Response> responses = new ArrayList<Response>();
            List<String> profiles = SpringCloudConfigClientConfigSourceFactory.determineProfiles(context, config);
            log.debug((Object)("The following profiles will be used to look up properties: " + profiles));
            for (String profile : profiles) {
                Response response = connectionTimeoutIsGreaterThanZero || readTimeoutIsGreaterThanZero ? (Response)client.exchange(applicationName, profile).await().atMost(config.connectionTimeout().plus(config.readTimeout().multipliedBy(2L))) : (Response)client.exchange(applicationName, profile).await().indefinitely();
                if (response.getProfiles().contains(profile)) {
                    responses.add(response);
                    continue;
                }
                log.debug((Object)("Response did not contain profile " + profile));
            }
            log.debug((Object)("Obtained " + responses.size() + " from the config server"));
            int ordinal = 450;
            Collections.reverse(responses);
            for (Response response : responses) {
                List<Response.PropertySource> propertySources = response.getPropertySources();
                Collections.reverse(propertySources);
                for (Response.PropertySource propertySource : propertySources) {
                    int ord = ordinal++;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding PropertySource named '" + propertySource.getName() + "', with and ordinal of '" + ord + "' that contains the following keys: " + String.join((CharSequence)",", propertySource.getSource().keySet())));
                    }
                    sources.add((ConfigSource)SpringCloudPropertySource.from(propertySource, response.getProfiles(), ord));
                }
            }
            ArrayList<ConfigSource> arrayList = sources;
            return arrayList;
        }
    }

    private static List<String> determineProfiles(ConfigSourceContext context, SpringCloudConfigClientConfig config) {
        if (config.profiles().isPresent()) {
            return config.profiles().get();
        }
        return context.getProfiles();
    }

    private static class SpringCloudPropertySource
    extends MapBackedConfigSource {
        private SpringCloudPropertySource(String name, Map<String, String> propertyMap, int defaultOrdinal) {
            super(name, propertyMap, defaultOrdinal);
        }

        static SpringCloudPropertySource from(Response.PropertySource propertySource, List<String> profiles, int ordinal) {
            HashMap<String, String> values = new HashMap<String, String>();
            Map<String, String> source = propertySource.getSource();
            for (String profile : profiles) {
                for (Map.Entry<String, String> entry : source.entrySet()) {
                    values.put("%" + profile + "." + entry.getKey(), entry.getValue());
                }
            }
            return new SpringCloudPropertySource(propertySource.getName(), values, ordinal);
        }
    }
}

