/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.deployment;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.security.runtime.interceptor.check.RolesAllowedCheck;
import io.quarkus.security.runtime.interceptor.check.SecurityCheck;
import io.quarkus.spring.security.deployment.roles.HasRoleValueProducer;
import io.quarkus.spring.security.runtime.interceptor.check.AllDelegatingSecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.AnonymousCheck;
import io.quarkus.spring.security.runtime.interceptor.check.AnyDelegatingSecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.PrincipalNameFromParameterObjectSecurityCheck;
import io.quarkus.spring.security.runtime.interceptor.check.PrincipalNameFromParameterSecurityCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

final class PreAuthorizeSecurityCheckUtil {
    private PreAuthorizeSecurityCheckUtil() {
    }

    public static Function<BytecodeCreator, ResultHandle> anonymousSecurityCheck() {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                return creator.readStaticField(FieldDescriptor.of(AnonymousCheck.class, (String)"INSTANCE", AnonymousCheck.class));
            }
        };
    }

    public static Function<BytecodeCreator, ResultHandle> hasRoleSecurityCheck(List<HasRoleValueProducer> hasRoleValueProducers) {
        return new HasRoleSecurityCheck(hasRoleValueProducers);
    }

    public static Function<BytecodeCreator, ResultHandle> principalNameFromParameterSecurityCheck(final int index, final PrincipalNameFromParameterSecurityCheck.CheckType checkType) {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                return creator.invokeStaticMethod(MethodDescriptor.ofMethod(PrincipalNameFromParameterSecurityCheck.class, (String)"of", PrincipalNameFromParameterSecurityCheck.class, (Class[])new Class[]{Integer.TYPE, PrincipalNameFromParameterSecurityCheck.CheckType.class}), new ResultHandle[]{creator.load(index), creator.readStaticField(FieldDescriptor.of(PrincipalNameFromParameterSecurityCheck.CheckType.class, (String)checkType.toString(), PrincipalNameFromParameterSecurityCheck.CheckType.class))});
            }
        };
    }

    public static Function<BytecodeCreator, ResultHandle> principalNameFromParameterObjectSecurityCheck(final int index, final String expectedParameterClass, final String stringPropertyAccessorClass, final String propertyName) {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                return creator.invokeStaticMethod(MethodDescriptor.ofMethod(PrincipalNameFromParameterObjectSecurityCheck.class, (String)"of", PrincipalNameFromParameterObjectSecurityCheck.class, (Class[])new Class[]{Integer.TYPE, String.class, String.class, String.class}), new ResultHandle[]{creator.load(index), creator.load(expectedParameterClass), creator.load(stringPropertyAccessorClass), creator.load(propertyName)});
            }
        };
    }

    public static Function<BytecodeCreator, ResultHandle> generateAllDelegatingSecurityCheck(List<Function<BytecodeCreator, ResultHandle>> delegatesList) {
        return PreAuthorizeSecurityCheckUtil.generateDelegatingSecurityCheck(delegatesList, AllDelegatingSecurityCheck.class);
    }

    public static Function<BytecodeCreator, ResultHandle> generateAnyDelegatingSecurityCheck(List<Function<BytecodeCreator, ResultHandle>> delegatesList) {
        return PreAuthorizeSecurityCheckUtil.generateDelegatingSecurityCheck(delegatesList, AnyDelegatingSecurityCheck.class);
    }

    private static Function<BytecodeCreator, ResultHandle> generateDelegatingSecurityCheck(final List<Function<BytecodeCreator, ResultHandle>> delegatesList, final Class<? extends SecurityCheck> securityCheckClass) {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                ResultHandle delegates = creator.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{creator.load(delegatesList.size())});
                for (Function delegateFunction : delegatesList) {
                    ResultHandle delegate = (ResultHandle)delegateFunction.apply(creator);
                    creator.invokeVirtualMethod(MethodDescriptor.ofMethod(ArrayList.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class}), delegates, new ResultHandle[]{delegate});
                }
                return creator.newInstance(MethodDescriptor.ofConstructor((Class)securityCheckClass, (Class[])new Class[]{List.class}), new ResultHandle[]{delegates});
            }
        };
    }

    public static Function<BytecodeCreator, ResultHandle> beanMethodGeneratedSecurityCheck(final String generatedClassName) {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                return creator.invokeStaticMethod(MethodDescriptor.ofMethod((String)generatedClassName, (String)"getInstance", (String)generatedClassName, (String[])new String[0]), new ResultHandle[0]);
            }
        };
    }

    private static class HasRoleSecurityCheck
    implements Function<BytecodeCreator, ResultHandle> {
        private final List<HasRoleValueProducer> roleValueProducers;

        private HasRoleSecurityCheck(List<HasRoleValueProducer> roleValueProducers) {
            this.roleValueProducers = roleValueProducers;
        }

        @Override
        public ResultHandle apply(BytecodeCreator creator) {
            ResultHandle rolesAllowedArgs = creator.newArray(String.class, creator.load(this.roleValueProducers.size()));
            int i = 0;
            for (Function function : this.roleValueProducers) {
                creator.writeArrayValue(rolesAllowedArgs, i++, (ResultHandle)function.apply(creator));
            }
            return creator.invokeStaticMethod(MethodDescriptor.ofMethod(RolesAllowedCheck.class, (String)"of", RolesAllowedCheck.class, (Class[])new Class[]{String[].class}), new ResultHandle[]{rolesAllowedArgs});
        }
    }
}

