/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.deployment;

import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.spring.security.runtime.interceptor.accessor.StringPropertyAccessor;
import java.util.Set;
import javax.inject.Singleton;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;

final class StringPropertyAccessorGenerator {
    private StringPropertyAccessorGenerator() {
    }

    static String getAccessorClassName(ClassInfo classInfo) {
        return "io.quarkus.spring.security.accessor." + classInfo.name().withoutPackagePrefix() + "_" + HashUtil.sha1((String)classInfo.name().toString()) + "_Accessor";
    }

    static String generate(ClassInfo classInfo, Set<FieldInfo> properties, ClassOutput classOutput) {
        String generatedClassName = StringPropertyAccessorGenerator.getAccessorClassName(classInfo);
        try (ClassCreator cc = ClassCreator.builder().classOutput(classOutput).className(generatedClassName).interfaces(new Class[]{StringPropertyAccessor.class}).build();){
            cc.addAnnotation(Singleton.class);
            try (MethodCreator access = cc.getMethodCreator("access", (Object)String.class.getName(), new Object[]{Object.class, String.class});){
                ResultHandle objectParam = access.getMethodParam(0);
                ResultHandle propertyParam = access.getMethodParam(1);
                ResultHandle castedObjectParam = access.checkCast(objectParam, classInfo.name().toString());
                for (FieldInfo fieldInfo : properties) {
                    ResultHandle propertyName = access.load(fieldInfo.name());
                    ResultHandle propertyNameEquals = access.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"equals", Boolean.TYPE, (Class[])new Class[]{Object.class}), propertyName, new ResultHandle[]{propertyParam});
                    BranchResult propertyNameEqualsBranch = access.ifNonZero(propertyNameEquals);
                    BytecodeCreator propertyNameEqualsTrue = propertyNameEqualsBranch.trueBranch();
                    ResultHandle result = propertyNameEqualsTrue.invokeVirtualMethod(MethodDescriptor.ofMethod((String)classInfo.name().toString(), (String)("get" + JavaBeanUtil.capitalize((String)fieldInfo.name())), (String)String.class.getName(), (String[])new String[0]), castedObjectParam, new ResultHandle[0]);
                    propertyNameEqualsTrue.returnValue(result);
                }
                access.throwException(IllegalArgumentException.class, "Property unknown");
            }
        }
        return generatedClassName;
    }
}

