/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.security.runtime.interceptor.check;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.interceptor.check.SecurityCheck;
import java.lang.reflect.Method;

public class PrincipalNameFromParameterSecurityCheck
implements SecurityCheck {
    private final int index;
    private final CheckType checkType;

    private PrincipalNameFromParameterSecurityCheck(int index, CheckType checkType) {
        this.index = index;
        this.checkType = checkType;
    }

    public static PrincipalNameFromParameterSecurityCheck of(int index, CheckType checkType) {
        return new PrincipalNameFromParameterSecurityCheck(index, checkType);
    }

    public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        if (this.index > parameters.length - 1) {
            throw this.genericNotApplicableException(method);
        }
        Object parameterValue = parameters[this.index];
        if (!(parameterValue instanceof String)) {
            throw this.genericNotApplicableException(method);
        }
        String parameterValueStr = (String)parameterValue;
        if (identity.isAnonymous()) {
            throw new UnauthorizedException();
        }
        String name = identity.getPrincipal().getName();
        if (this.checkType == CheckType.EQ ? !name.equals(parameterValueStr) : this.checkType == CheckType.NEQ && name.equals(parameterValueStr)) {
            throw new ForbiddenException();
        }
    }

    private IllegalStateException genericNotApplicableException(Method method) {
        return new IllegalStateException("PrincipalNameFromParameterSecurityCheck with index " + this.index + " cannot be applied to " + method);
    }

    public static enum CheckType {
        EQ,
        NEQ;

    }
}

