/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

abstract class AbstractExceptionMapperGenerator {
    protected static final DotName RESPONSE_STATUS = DotName.createSimple((String)"org.springframework.web.bind.annotation.ResponseStatus");
    protected final DotName exceptionDotName;
    protected final ClassOutput classOutput;

    AbstractExceptionMapperGenerator(DotName exceptionDotName, ClassOutput classOutput) {
        this.exceptionDotName = exceptionDotName;
        this.classOutput = classOutput;
    }

    abstract void generateMethodBody(MethodCreator var1);

    String generate() {
        String generatedClassName = "io.quarkus.spring.web.mappers." + this.exceptionDotName.withoutPackagePrefix() + "Mapper";
        String generatedSubtypeClassName = "io.quarkus.spring.web.mappers.Subtype" + this.exceptionDotName.withoutPackagePrefix() + "Mapper";
        String exceptionClassName = this.exceptionDotName.toString();
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(generatedClassName).interfaces(new Class[]{ExceptionMapper.class}).signature(String.format("Ljava/lang/Object;Ljavax/ws/rs/ext/ExceptionMapper<L%s;>;", exceptionClassName.replace('.', '/'))).build();){
            this.preGenerateMethodBody(cc);
            try (MethodCreator toResponse = cc.getMethodCreator("toResponse", Response.class.getName(), new String[]{exceptionClassName});){
                this.generateMethodBody(toResponse);
            }
            var7_11 = null;
            try (MethodCreator bridgeToResponse = cc.getMethodCreator("toResponse", Response.class, new Class[]{Throwable.class});){
                MethodDescriptor toResponse = MethodDescriptor.ofMethod((String)generatedClassName, (String)"toResponse", (String)Response.class.getName(), (String[])new String[]{exceptionClassName});
                ResultHandle castedObject = bridgeToResponse.checkCast(bridgeToResponse.getMethodParam(0), exceptionClassName);
                ResultHandle result = bridgeToResponse.invokeVirtualMethod(toResponse, bridgeToResponse.getThis(), new ResultHandle[]{castedObject});
                bridgeToResponse.returnValue(result);
            }
            catch (Throwable throwable) {
                var7_11 = throwable;
                throw throwable;
            }
        }
        cc = ClassCreator.builder().classOutput(this.classOutput).className(generatedSubtypeClassName).superClass(generatedClassName).build();
        var5_5 = null;
        try {
            cc.addAnnotation(Provider.class);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (cc != null) {
                if (var5_5 != null) {
                    try {
                        cc.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    cc.close();
                }
            }
        }
        return generatedSubtypeClassName;
    }

    protected void preGenerateMethodBody(ClassCreator cc) {
    }

    protected int getHttpStatusFromAnnotation(AnnotationInstance responseStatusInstance) {
        AnnotationValue code = responseStatusInstance.value("code");
        if (code != null) {
            return this.enumValueToHttpStatus(code.asString());
        }
        AnnotationValue value = responseStatusInstance.value();
        if (value != null) {
            return this.enumValueToHttpStatus(value.asString());
        }
        return 500;
    }

    private int enumValueToHttpStatus(String enumValue) {
        try {
            Class<?> httpStatusClass = Class.forName("org.springframework.http.HttpStatus");
            Object correspondingEnum = Enum.valueOf(httpStatusClass, enumValue);
            Method valueMethod = httpStatusClass.getDeclaredMethod("value", new Class[0]);
            return (Integer)valueMethod.invoke(correspondingEnum, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("No spring web dependency found on the build classpath");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

