/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.spring.web.deployment.AbstractExceptionMapperGenerator;
import io.quarkus.spring.web.deployment.TypesUtil;
import io.quarkus.spring.web.runtime.ResponseEntityConverter;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class ControllerAdviceAbstractExceptionMapperGenerator
extends AbstractExceptionMapperGenerator {
    private static final DotName RESPONSE_ENTITY = DotName.createSimple((String)"org.springframework.http.ResponseEntity");
    private final MethodInfo controllerAdviceMethod;
    private final TypesUtil typesUtil;
    private final Type returnType;
    private final List<Type> parameterTypes;
    private final String declaringClassName;
    private final Map<Type, FieldDescriptor> parameterTypeToField = new HashMap<Type, FieldDescriptor>();

    ControllerAdviceAbstractExceptionMapperGenerator(MethodInfo controllerAdviceMethod, DotName exceptionDotName, ClassOutput classOutput, TypesUtil typesUtil) {
        super(exceptionDotName, classOutput);
        this.controllerAdviceMethod = controllerAdviceMethod;
        this.typesUtil = typesUtil;
        this.returnType = controllerAdviceMethod.returnType();
        this.parameterTypes = controllerAdviceMethod.parameters();
        this.declaringClassName = controllerAdviceMethod.declaringClass().name().toString();
    }

    @Override
    protected void preGenerateMethodBody(ClassCreator cc) {
        int notAllowedParameterIndex = -1;
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            FieldCreator httpRequestFieldCreator;
            Type parameterType = this.parameterTypes.get(i);
            DotName parameterTypeDotName = parameterType.name();
            if (this.typesUtil.isAssignable(Exception.class, parameterTypeDotName)) continue;
            if (this.typesUtil.isAssignable(HttpServletRequest.class, parameterTypeDotName)) {
                if (this.parameterTypeToField.containsKey(parameterType)) {
                    throw new IllegalArgumentException("Parameter type " + this.parameterTypes.get(notAllowedParameterIndex).name() + " is being used multiple times in method" + this.controllerAdviceMethod.name() + " of class" + this.controllerAdviceMethod.declaringClass().name());
                }
                httpRequestFieldCreator = (FieldCreator)cc.getFieldCreator("httpServletRequest", HttpServletRequest.class).setModifiers(2);
                httpRequestFieldCreator.addAnnotation(Context.class);
                this.parameterTypeToField.put(parameterType, httpRequestFieldCreator.getFieldDescriptor());
                continue;
            }
            if (this.typesUtil.isAssignable(HttpServletResponse.class, parameterTypeDotName)) {
                if (this.parameterTypeToField.containsKey(parameterType)) {
                    throw new IllegalArgumentException("Parameter type " + this.parameterTypes.get(notAllowedParameterIndex).name() + " is being used multiple times in method" + this.controllerAdviceMethod.name() + " of class" + this.controllerAdviceMethod.declaringClass().name());
                }
                httpRequestFieldCreator = (FieldCreator)cc.getFieldCreator("httpServletResponse", HttpServletResponse.class).setModifiers(2);
                httpRequestFieldCreator.addAnnotation(Context.class);
                this.parameterTypeToField.put(parameterType, httpRequestFieldCreator.getFieldDescriptor());
                continue;
            }
            notAllowedParameterIndex = i;
        }
        if (notAllowedParameterIndex >= 0) {
            throw new IllegalArgumentException("Parameter type " + this.parameterTypes.get(notAllowedParameterIndex).name() + " is not supported for method" + this.controllerAdviceMethod.name() + " of class" + this.controllerAdviceMethod.declaringClass().name());
        }
    }

    @Override
    void generateMethodBody(MethodCreator toResponse) {
        if (this.returnType.kind() == Type.Kind.VOID) {
            AnnotationInstance responseStatusInstance = this.controllerAdviceMethod.annotation(RESPONSE_STATUS);
            if (responseStatusInstance == null) {
                throw new IllegalStateException("void methods annotated with @ExceptionHandler must also be annotated with @ResponseStatus");
            }
            this.exceptionHandlerMethodResponse(toResponse);
            ResultHandle status = toResponse.load(this.getHttpStatusFromAnnotation(responseStatusInstance));
            ResultHandle responseBuilder = toResponse.invokeStaticMethod(MethodDescriptor.ofMethod(Response.class, (String)"status", Response.ResponseBuilder.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{status});
            ResultHandle httpResponseType = toResponse.load("text/plain");
            toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"type", Response.ResponseBuilder.class, (Class[])new Class[]{String.class}), responseBuilder, new ResultHandle[]{httpResponseType});
            ResultHandle response = toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"build", Response.class, (Class[])new Class[0]), responseBuilder, new ResultHandle[0]);
            toResponse.returnValue(response);
        } else {
            ResultHandle response;
            ResultHandle exceptionHandlerMethodResponse = this.exceptionHandlerMethodResponse(toResponse);
            if (RESPONSE_ENTITY.equals((Object)this.returnType.name())) {
                response = toResponse.invokeStaticMethod(MethodDescriptor.ofMethod((String)ResponseEntityConverter.class.getName(), (String)"toResponse", (String)Response.class.getName(), (String[])new String[]{RESPONSE_ENTITY.toString()}), new ResultHandle[]{exceptionHandlerMethodResponse});
            } else {
                ResultHandle status = toResponse.load(this.getStatus(this.controllerAdviceMethod.annotation(RESPONSE_STATUS)));
                ResultHandle responseBuilder = toResponse.invokeStaticMethod(MethodDescriptor.ofMethod(Response.class, (String)"status", Response.ResponseBuilder.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{status});
                toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"entity", Response.ResponseBuilder.class, (Class[])new Class[]{Object.class}), responseBuilder, new ResultHandle[]{exceptionHandlerMethodResponse});
                response = toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"build", Response.class, (Class[])new Class[0]), responseBuilder, new ResultHandle[0]);
            }
            toResponse.returnValue(response);
        }
    }

    private ResultHandle exceptionHandlerMethodResponse(MethodCreator toResponse) {
        String returnTypeClassName;
        String string = returnTypeClassName = this.returnType.kind() == Type.Kind.VOID ? Void.TYPE.getName() : this.returnType.name().toString();
        if (this.parameterTypes.isEmpty()) {
            return toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod((String)this.declaringClassName, (String)this.controllerAdviceMethod.name(), (String)returnTypeClassName, (String[])new String[0]), this.controllerAdviceInstance(toResponse), new ResultHandle[0]);
        }
        String[] parameterTypesStr = new String[this.parameterTypes.size()];
        ResultHandle[] parameterTypeHandles = new ResultHandle[this.parameterTypes.size()];
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            Type parameterType = this.parameterTypes.get(i);
            parameterTypesStr[i] = parameterType.name().toString();
            parameterTypeHandles[i] = this.typesUtil.isAssignable(Exception.class, parameterType.name()) ? toResponse.getMethodParam(i) : toResponse.readInstanceField(this.parameterTypeToField.get(parameterType), toResponse.getThis());
        }
        return toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod((String)this.declaringClassName, (String)this.controllerAdviceMethod.name(), (String)returnTypeClassName, (String[])parameterTypesStr), this.controllerAdviceInstance(toResponse), parameterTypeHandles);
    }

    private ResultHandle controllerAdviceInstance(MethodCreator toResponse) {
        ResultHandle controllerAdviceClass = toResponse.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{toResponse.load(this.declaringClassName)});
        ResultHandle container = toResponse.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instance = toResponse.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), container, new ResultHandle[]{controllerAdviceClass, toResponse.loadNull()});
        ResultHandle bean = toResponse.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instance, new ResultHandle[0]);
        return toResponse.checkCast(bean, this.controllerAdviceMethod.declaringClass().name().toString());
    }

    private int getStatus(AnnotationInstance instance) {
        if (instance == null) {
            return 200;
        }
        return this.getHttpStatusFromAnnotation(instance);
    }
}

