/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.IntegrationTestStartedNotifier;
import io.quarkus.test.common.JarArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.ProcessReader;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DefaultJarLauncher
implements JarArtifactLauncher {
    private static final String JAVA_HOME_SYS = "java.home";
    private static final String JAVA_HOME_ENV = "JAVA_HOME";
    private static final String VERTX_HTTP_RECORDER = "io.quarkus.vertx.http.runtime.VertxHttpRecorder";
    static boolean HTTP_PRESENT;
    private int httpPort;
    private int httpsPort;
    private long waitTimeSeconds;
    private String testProfile;
    private List<String> argLine;
    private Path jarPath;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private Process quarkusProcess;
    private boolean isSsl;

    @Override
    public void init(JarArtifactLauncher.JarInitContext initContext) {
        this.httpPort = initContext.httpPort();
        this.httpsPort = initContext.httpsPort();
        this.waitTimeSeconds = initContext.waitTime().getSeconds();
        this.testProfile = initContext.testProfile();
        this.argLine = initContext.argLine();
        this.jarPath = initContext.jarPath();
    }

    @Override
    public void start() throws IOException {
        this.start(new String[0], true);
        Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> startedFunction = LauncherUtil.createStartedFunction();
        Path logFile = PropertyTestUtil.getLogFilePath();
        if (startedFunction != null) {
            IntegrationTestStartedNotifier.Result result = LauncherUtil.waitForStartedFunction(startedFunction, this.quarkusProcess, this.waitTimeSeconds, logFile);
            this.isSsl = result.isSsl();
        } else {
            ListeningAddress result = LauncherUtil.waitForCapturedListeningData(this.quarkusProcess, logFile, this.waitTimeSeconds);
            LauncherUtil.updateConfigForPort(result.getPort());
            this.isSsl = result.isSsl();
        }
    }

    @Override
    public ArtifactLauncher.LaunchResult runToCompletion(String[] args) {
        try {
            this.start(args, false);
            ProcessReader error = new ProcessReader(this.quarkusProcess.getErrorStream());
            ProcessReader stdout = new ProcessReader(this.quarkusProcess.getInputStream());
            Thread t = new Thread((Runnable)error, "Error stream reader");
            t.start();
            t = new Thread((Runnable)stdout, "Stdout stream reader");
            t.start();
            byte[] s = stdout.get();
            byte[] e = error.get();
            return new ArtifactLauncher.LaunchResult(this.quarkusProcess.waitFor(), s, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start(String[] programArgs, boolean handleIo) throws IOException {
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.determineJavaPath());
        if (!this.argLine.isEmpty()) {
            args.addAll(this.argLine);
        }
        if (HTTP_PRESENT) {
            args.add("-Dquarkus.http.port=" + this.httpPort);
            args.add("-Dquarkus.http.ssl-port=" + this.httpsPort);
            args.add("-Dtest.url=" + TestHTTPResourceManager.getUri());
        }
        Path logFile = PropertyTestUtil.getLogFilePath();
        args.add("-Dquarkus.log.file.path=" + logFile.toAbsolutePath().toString());
        args.add("-Dquarkus.log.file.enable=true");
        if (this.testProfile != null) {
            args.add("-Dquarkus.profile=" + this.testProfile);
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.add("-D" + e.getKey() + "=" + e.getValue());
        }
        args.add("-jar");
        args.add(this.jarPath.toAbsolutePath().toString());
        args.addAll(Arrays.asList(programArgs));
        System.out.println("Executing \"" + String.join((CharSequence)" ", args) + "\"");
        Files.deleteIfExists(logFile);
        Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        this.quarkusProcess = handleIo ? LauncherUtil.launchProcess(args) : Runtime.getRuntime().exec(args.toArray(new String[0]));
    }

    private String determineJavaPath() {
        File javaHome;
        File file;
        String home = System.getProperty(JAVA_HOME_SYS);
        if (home == null) {
            home = System.getenv(JAVA_HOME_ENV);
        }
        if (home != null && (file = new File(javaHome = new File(home), "bin/java")).exists()) {
            return file.getAbsolutePath();
        }
        return "java";
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void includeAsSysProps(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        LauncherUtil.destroyProcess(this.quarkusProcess);
    }

    static {
        boolean http = true;
        try {
            Class.forName(VERTX_HTTP_RECORDER);
        }
        catch (ClassNotFoundException e) {
            http = false;
        }
        HTTP_PRESENT = http;
    }
}

