/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

public class KnownPathResourceManager
implements ResourceManager {
    private final NavigableSet<String> files;
    private final Set<String> directories;
    private final ResourceManager underlying;

    public KnownPathResourceManager(Set<String> files, Set<String> directories, ResourceManager underlying) {
        this.underlying = underlying;
        TreeSet<String> tree = new TreeSet<String>();
        for (String i : files) {
            if (i.startsWith("/")) {
                i = i.substring(1);
            }
            if (i.endsWith("/")) {
                i = i.substring(0, i.length() - 1);
            }
            tree.add(i);
        }
        this.files = tree;
        HashSet<String> tmp = new HashSet<String>();
        for (String i : directories) {
            if (i.startsWith("/")) {
                i = i.substring(1);
            }
            if (i.endsWith("/")) {
                i = i.substring(0, i.length() - 1);
            }
            tmp.add(i);
        }
        tmp.add("");
        this.directories = Collections.unmodifiableSet(tmp);
    }

    public Resource getResource(String path) throws IOException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (this.directories.contains(path)) {
            return new DirectoryResource(path);
        }
        return this.underlying.getResource(path);
    }

    public boolean isResourceChangeListenerSupported() {
        return this.underlying.isResourceChangeListenerSupported();
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        this.underlying.registerResourceChangeListener(listener);
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        this.underlying.removeResourceChangeListener(listener);
    }

    public void close() throws IOException {
        this.underlying.close();
    }

    private class DirectoryResource
    implements Resource {
        private final String path;

        private DirectoryResource(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public Date getLastModified() {
            return null;
        }

        public String getLastModifiedString() {
            return null;
        }

        public ETag getETag() {
            return null;
        }

        public String getName() {
            int i = this.path.lastIndexOf(47);
            if (i == -1) {
                return this.path;
            }
            return this.path.substring(i + 1);
        }

        public boolean isDirectory() {
            return true;
        }

        public List<Resource> list() {
            String i;
            ArrayList<Resource> ret = new ArrayList<Resource>();
            String slashPath = this.path + "/";
            Iterator iterator = KnownPathResourceManager.this.files.headSet(this.path).iterator();
            while (iterator.hasNext() && (i = (String)iterator.next()).startsWith(slashPath)) {
                try {
                    ret.add(KnownPathResourceManager.this.underlying.getResource(i));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return ret;
        }

        public String getContentType(MimeMappings mimeMappings) {
            return null;
        }

        public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
            completionCallback.onException(exchange, sender, new IOException("Cannot serve directory"));
        }

        public Long getContentLength() {
            return null;
        }

        public String getCacheKey() {
            return null;
        }

        public File getFile() {
            return null;
        }

        public Path getFilePath() {
            return null;
        }

        public File getResourceManagerRoot() {
            return null;
        }

        public Path getResourceManagerRootPath() {
            return null;
        }

        public URL getUrl() {
            return null;
        }
    }
}

