/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.runtime.TemplateHtmlBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class QuarkusErrorServlet
extends HttpServlet {
    public static final String SHOW_STACK = "show-stack";

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String details = "";
        String stack = "";
        Object uuid = req.getAttribute("quarkus.error.id");
        Throwable exception = (Throwable)req.getAttribute("javax.servlet.error.exception");
        String errorMessage = (String)req.getAttribute("javax.servlet.error.message");
        if (errorMessage != null) {
            details = errorMessage;
        }
        if (Boolean.parseBoolean(this.getInitParameter(SHOW_STACK)) && exception != null) {
            details = QuarkusErrorServlet.generateHeaderMessage(exception, uuid == null ? null : uuid.toString());
            stack = QuarkusErrorServlet.generateStackTrace(exception);
        } else if (uuid != null) {
            details = details + "Error id " + uuid;
        }
        resp.setContentType("text/html");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resp.getWriter().write(new TemplateHtmlBuilder().error(details).stack(stack).toString());
    }

    private static String generateStackTrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return QuarkusErrorServlet.escapeHtml(stringWriter.toString().trim());
    }

    private static String generateHeaderMessage(Throwable exception, String uuid) {
        return QuarkusErrorServlet.escapeHtml(String.format("Error handling %s, %s: %s", uuid, exception.getClass().getName(), QuarkusErrorServlet.extractFirstLine(exception.getMessage())));
    }

    private static String extractFirstLine(String message) {
        if (null == message) {
            return "";
        }
        String[] lines = message.split("\\r?\\n");
        return lines[0].trim();
    }

    private static String escapeHtml(String bodyText) {
        if (bodyText == null) {
            return "null";
        }
        return bodyText.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

