/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.runtime.test.TestHttpEndpointProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.annotation.WebServlet;
import org.eclipse.microprofile.config.ConfigProvider;

public class UndertowTestHttpProvider
implements TestHttpEndpointProvider {
    public Function<Class<?>, String> endpointProvider() {
        return new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> aClass) {
                Object value = null;
                for (Annotation annotation : aClass.getAnnotations()) {
                    if (!annotation.annotationType().getName().equals(WebServlet.class.getName())) continue;
                    try {
                        String[] patterns = (String[])annotation.annotationType().getMethod("urlPatterns", new Class[0]).invoke((Object)annotation, new Object[0]);
                        if (patterns.length <= 0) continue;
                        value = patterns[0];
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (value == null) {
                    return null;
                }
                if (((String)value).endsWith("/*")) {
                    value = ((String)value).substring(0, ((String)value).length() - 1);
                }
                if (((String)value).startsWith("/")) {
                    value = ((String)value).substring(1);
                }
                Object path = "/";
                Optional appPath = ConfigProvider.getConfig().getOptionalValue("quarkus.servlet.context-path", String.class);
                if (appPath.isPresent()) {
                    path = (String)appPath.get();
                }
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                value = (String)path + (String)value;
                return value;
            }
        };
    }
}

