/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.deployment.devmode.ReplacementDebugPage;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;

public class VertxHotReplacementSetup
implements HotReplacementSetup {
    private volatile long nextUpdate;
    private HotReplacementContext hotReplacementContext;
    private static final long HOT_REPLACEMENT_INTERVAL = 2000L;
    private static final String HEADER_NAME = "x-quarkus-hot-deployment-done";

    public void setupHotDeployment(HotReplacementContext context) {
        this.hotReplacementContext = context;
        VertxHttpRecorder.setHotReplacement(this::handleHotReplacementRequest);
    }

    public void handleFailedInitialStart() {
        VertxHttpRecorder.startServerAfterFailedStart();
    }

    void handleHotReplacementRequest(final RoutingContext routingContext) {
        if (this.nextUpdate > System.currentTimeMillis() && !this.hotReplacementContext.isTest() || routingContext.request().headers().contains(HEADER_NAME)) {
            if (this.hotReplacementContext.getDeploymentProblem() != null) {
                VertxHotReplacementSetup.handleDeploymentProblem(routingContext, this.hotReplacementContext.getDeploymentProblem());
                return;
            }
            routingContext.next();
            return;
        }
        routingContext.request().pause();
        routingContext.vertx().executeBlocking((Handler)new Handler<Promise<Boolean>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Promise<Boolean> event) {
                boolean restart = false;
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (VertxHotReplacementSetup.this.nextUpdate < System.currentTimeMillis() || VertxHotReplacementSetup.this.hotReplacementContext.isTest()) {
                        VertxHotReplacementSetup.this.nextUpdate = System.currentTimeMillis() + 2000L;
                        try {
                            restart = VertxHotReplacementSetup.this.hotReplacementContext.doScan(true);
                        }
                        catch (Exception e) {
                            event.fail((Throwable)new IllegalStateException("Unable to perform hot replacement scanning", e));
                            return;
                        }
                    }
                }
                if (VertxHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem() != null) {
                    event.fail(VertxHotReplacementSetup.this.hotReplacementContext.getDeploymentProblem());
                    return;
                }
                event.complete((Object)restart);
            }
        }, false, (Handler)new Handler<AsyncResult<Boolean>>(){

            public void handle(AsyncResult<Boolean> event) {
                if (!routingContext.request().isEnded()) {
                    routingContext.request().resume();
                }
                if (event.failed()) {
                    VertxHotReplacementSetup.handleDeploymentProblem(routingContext, event.cause());
                } else {
                    boolean restart = (Boolean)event.result();
                    if (restart) {
                        routingContext.request().headers().set(VertxHotReplacementSetup.HEADER_NAME, "true");
                        VertxHttpRecorder.getRootHandler().handle((Object)routingContext.request());
                    } else {
                        routingContext.next();
                    }
                }
            }
        });
    }

    public static void handleDeploymentProblem(RoutingContext routingContext, Throwable exception) {
        String bodyText = ReplacementDebugPage.generateHtml((Throwable)exception);
        HttpServerResponse response = routingContext.response();
        response.setStatusCode(500);
        response.headers().add("Content-Type", "text/html; charset=UTF-8");
        response.end(bodyText);
    }

    public void close() {
        VertxHttpRecorder.shutDownDevMode();
    }
}

