/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.vertx.core.http.HttpServerRequest;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class RolesAllowedHttpSecurityPolicy
implements HttpSecurityPolicy {
    private List<String> rolesAllowed;

    public RolesAllowedHttpSecurityPolicy(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
    }

    public RolesAllowedHttpSecurityPolicy() {
    }

    public List<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    public RolesAllowedHttpSecurityPolicy setRolesAllowed(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
        return this;
    }

    @Override
    public CompletionStage<HttpSecurityPolicy.CheckResult> checkPermission(HttpServerRequest request, SecurityIdentity identity) {
        for (String i : this.rolesAllowed) {
            if (!identity.hasRole(i)) continue;
            return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.PERMIT);
        }
        return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.DENY);
    }
}

