/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;

public class HttpCompressionHandler
implements Handler<RoutingContext> {
    private final Handler<RoutingContext> routeHandler;
    private final Set<String> compressedMediaTypes;

    public HttpCompressionHandler(Handler<RoutingContext> routeHandler, Set<String> compressedMediaTypes) {
        this.routeHandler = routeHandler;
        this.compressedMediaTypes = compressedMediaTypes;
    }

    public void handle(final RoutingContext context) {
        context.addEndHandler((Handler)new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> result) {
                if (result.succeeded()) {
                    HttpCompressionHandler.compressIfNeeded(context, HttpCompressionHandler.this.compressedMediaTypes);
                }
            }
        });
        this.routeHandler.handle((Object)context);
    }

    public static void compressIfNeeded(RoutingContext context, Set<String> compressedMediaTypes) {
        String contentType;
        MultiMap headers = context.response().headers();
        String contentEncoding = headers.get(HttpHeaders.CONTENT_ENCODING);
        if (contentEncoding != null && HttpHeaders.IDENTITY.toString().equals(contentEncoding) && (contentType = headers.get(HttpHeaders.CONTENT_TYPE)) != null) {
            int paramIndex = contentType.indexOf(59);
            if (paramIndex > -1) {
                contentType = contentType.substring(0, paramIndex);
            }
            if (compressedMediaTypes.contains(contentType)) {
                headers.remove(HttpHeaders.CONTENT_ENCODING);
            }
        }
    }
}

