/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime.context;

import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;

public final class VertxContextSafetyToggle {
    private static final Object ACCESS_TOGGLE_KEY = new Object();
    public static final String RESTRICT_BY_DEFAULT_PROPERTY = "io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle.RESTRICT_BY_DEFAULT";
    private static final boolean RESTRICT_BY_DEFAULT = Boolean.getBoolean("io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle.RESTRICT_BY_DEFAULT");

    public static void validateContextIfExists(String errorMessageOnVeto, String errorMessageOnDoubt) {
        Context context = Vertx.currentContext();
        if (context != null) {
            VertxContextSafetyToggle.checkIsSafe(context, errorMessageOnVeto, errorMessageOnDoubt);
        }
    }

    private static void checkIsSafe(Context context, String errorMessageOnVeto, String errorMessageOnDoubt) {
        if (!VertxContext.isDuplicatedContext((Context)context)) {
            throw new IllegalStateException("Can't get the context safety flag: the current context is not a duplicated context");
        }
        Object safeFlag = context.getLocal(ACCESS_TOGGLE_KEY);
        if (safeFlag == Boolean.TRUE) {
            return;
        }
        if (safeFlag == null && !RESTRICT_BY_DEFAULT) {
            return;
        }
        if (safeFlag == null) {
            throw new IllegalStateException(errorMessageOnDoubt);
        }
        throw new IllegalStateException(errorMessageOnVeto);
    }

    public static void setCurrentContextSafe(boolean safe) {
        Context context = Vertx.currentContext();
        if (context == null) {
            throw new IllegalStateException("Can't set the context safety flag: no Vert.x context found");
        }
        if (!VertxContext.isDuplicatedContext((Context)context)) {
            throw new IllegalStateException("Can't set the context safety flag: the current context is not a duplicated context");
        }
        context.putLocal(ACCESS_TOGGLE_KEY, (Object)safe);
    }
}

