/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.Evaluator;
import io.quarkus.qute.EvaluatorImpl;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.Parser;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.Variant;
import io.quarkus.qute.WithPriority;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.logging.Logger;

class EngineImpl
implements Engine {
    private static final Logger LOGGER = Logger.getLogger(EngineImpl.class);
    private final Map<String, SectionHelperFactory<?>> sectionHelperFactories;
    private final Function<String, SectionHelperFactory<?>> sectionHelperFunc;
    private final List<ValueResolver> valueResolvers;
    private final List<NamespaceResolver> namespaceResolvers;
    private final Evaluator evaluator;
    private final Map<String, Template> templates;
    private final List<TemplateLocator> locators;
    private final List<ResultMapper> resultMappers;
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final List<ParserHook> parserHooks;
    final boolean removeStandaloneLines;

    EngineImpl(EngineBuilder builder) {
        this.sectionHelperFactories = Collections.unmodifiableMap(new HashMap(builder.sectionHelperFactories));
        this.valueResolvers = EngineImpl.sort(builder.valueResolvers);
        this.namespaceResolvers = ImmutableList.builder().addAll(builder.namespaceResolvers).add(new TemplateImpl.DataNamespaceResolver()).build();
        this.evaluator = new EvaluatorImpl(this.valueResolvers, this.namespaceResolvers);
        this.templates = new ConcurrentHashMap<String, Template>();
        this.locators = EngineImpl.sort(builder.locators);
        this.resultMappers = EngineImpl.sort(builder.resultMappers);
        this.sectionHelperFunc = builder.sectionHelperFunc;
        this.parserHooks = ImmutableList.copyOf(builder.parserHooks);
        this.removeStandaloneLines = builder.removeStandaloneLines;
    }

    @Override
    public Template parse(String content, Variant variant, String id) {
        String generatedId = this.generateId();
        return this.newParser(id != null ? id : generatedId, new StringReader(content), Optional.ofNullable(variant), generatedId).parse();
    }

    private Parser newParser(String id, Reader reader, Optional<Variant> variant, String generatedId) {
        Parser parser = new Parser(this, reader, id, generatedId, variant);
        for (ParserHook parserHook : this.parserHooks) {
            parserHook.beforeParsing(parser);
        }
        return parser;
    }

    @Override
    public SectionHelperFactory<?> getSectionHelperFactory(String name) {
        SectionHelperFactory<?> factory = this.sectionHelperFactories.get(name);
        if (factory != null) {
            return factory;
        }
        return this.sectionHelperFunc != null ? this.sectionHelperFunc.apply(name) : null;
    }

    @Override
    public Map<String, SectionHelperFactory<?>> getSectionHelperFactories() {
        return this.sectionHelperFactories;
    }

    @Override
    public List<ValueResolver> getValueResolvers() {
        return this.valueResolvers;
    }

    @Override
    public List<NamespaceResolver> getNamespaceResolvers() {
        return this.namespaceResolvers;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public List<ResultMapper> getResultMappers() {
        return this.resultMappers;
    }

    @Override
    public Template putTemplate(String id, Template template) {
        return this.templates.put(id, template);
    }

    @Override
    public Template getTemplate(String id) {
        return this.templates.computeIfAbsent(id, this::load);
    }

    @Override
    public void clearTemplates() {
        this.templates.clear();
    }

    @Override
    public void removeTemplates(Predicate<String> test) {
        this.templates.keySet().removeIf(test);
    }

    String generateId() {
        return "" + this.idGenerator.incrementAndGet();
    }

    private Template load(String id) {
        for (TemplateLocator locator : this.locators) {
            Template template;
            block9: {
                Optional<TemplateLocator.TemplateLocation> location = locator.locate(id);
                if (!location.isPresent()) continue;
                Reader r = location.get().read();
                try {
                    template = this.newParser(id, this.ensureBufferedReader(r), location.get().getVariant(), this.generateId()).parse();
                    if (r == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)("Unable to close the reader for " + id), (Throwable)e);
                    }
                }
                r.close();
            }
            return template;
        }
        return null;
    }

    private static <T extends WithPriority> List<T> sort(Collection<T> items) {
        ArrayList<T> sorted = new ArrayList<T>(items);
        sorted.sort(Comparator.comparingInt(WithPriority::getPriority).reversed());
        return ImmutableList.copyOf(sorted);
    }

    private Reader ensureBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? reader : new BufferedReader(reader);
    }
}

