/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.ErrorInitializer;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.LineSeparatorNode;
import io.quarkus.qute.LiteralSupport;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.ParameterDeclarationNode;
import io.quarkus.qute.ParserError;
import io.quarkus.qute.ParserHelper;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.Results;
import io.quarkus.qute.Scope;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateImpl;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.TextNode;
import io.quarkus.qute.Variant;
import io.quarkus.qute.WithOrigin;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class Parser
implements ParserHelper,
SectionHelperFactory.ParserDelegate,
WithOrigin,
ErrorInitializer {
    private static final Logger LOGGER = Logger.getLogger(Parser.class);
    static final String ROOT_HELPER_NAME = "$root";
    static final TemplateNode.Origin SYNTHETIC_ORIGIN = new OriginImpl(0, 0, 0, "<<synthetic>>", "<<synthetic>>", Optional.empty());
    private static final char START_DELIMITER = '{';
    private static final char END_DELIMITER = '}';
    private static final char COMMENT_DELIMITER = '!';
    private static final char CDATA_START_DELIMITER = '|';
    private static final char CDATA_END_DELIMITER = '|';
    private static final char UNDERSCORE = '_';
    private static final char ESCAPE_CHAR = '\\';
    private static final char NAMESPACE_SEPARATOR = ':';
    private static final char LINE_SEPARATOR_LF = '\n';
    private static final char LINE_SEPARATOR_CR = '\r';
    static final char START_COMPOSITE_PARAM = '(';
    static final char END_COMPOSITE_PARAM = ')';
    private final EngineImpl engine;
    private final Reader reader;
    private final Optional<Variant> variant;
    private final String templateId;
    private final String generatedId;
    private StringBuilder buffer;
    private State state;
    private int line;
    private int lineCharacter;
    private final Deque<SectionNode.Builder> sectionStack;
    private final Deque<SectionHelperFactory.ParametersInfo> paramsStack;
    private final Deque<Scope> scopeStack;
    private int sectionBlockIdx;
    private boolean ignoreContent;
    private AtomicInteger expressionIdGenerator;
    private final List<Function<String, String>> contentFilters;
    private boolean hasLineSeparator;
    private int paramDeclarationDefaults;
    private static final SectionHelper ROOT_SECTION_HELPER = new SectionHelper(){

        @Override
        public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
            return context.execute();
        }
    };
    private static final SectionHelperFactory<SectionHelper> ROOT_SECTION_HELPER_FACTORY = new SectionHelperFactory<SectionHelper>(){

        @Override
        public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return ROOT_SECTION_HELPER;
        }
    };
    private static final BlockNode BLOCK_NODE = new BlockNode();
    static final CommentNode COMMENT_NODE = new CommentNode();

    public Parser(EngineImpl engine, Reader reader, String templateId, String generatedId, Optional<Variant> variant) {
        this.engine = engine;
        this.templateId = templateId;
        this.generatedId = generatedId;
        this.variant = variant;
        this.reader = reader;
        this.state = State.TEXT;
        this.buffer = new StringBuilder();
        this.sectionStack = new ArrayDeque<SectionNode.Builder>();
        this.sectionBlockIdx = 0;
        this.paramsStack = new ArrayDeque<SectionHelperFactory.ParametersInfo>();
        this.paramsStack.addFirst(SectionHelperFactory.ParametersInfo.EMPTY);
        this.scopeStack = new ArrayDeque<Scope>();
        this.scopeStack.addFirst(new Scope(null));
        this.line = 1;
        this.lineCharacter = 1;
        this.expressionIdGenerator = new AtomicInteger();
        this.contentFilters = new ArrayList<Function<String, String>>(5);
    }

    Template parse() {
        this.sectionStack.addFirst(SectionNode.builder(ROOT_HELPER_NAME, this.origin(0), this, this).setEngine(this.engine).setHelperFactory(ROOT_SECTION_HELPER_FACTORY));
        long start = System.nanoTime();
        Reader r = this.reader;
        try {
            int val;
            if (!this.contentFilters.isEmpty()) {
                String contents = Parser.toString(this.reader);
                for (Function<String, String> filter : this.contentFilters) {
                    contents = filter.apply(contents);
                }
                r = new StringReader(contents);
            }
            while ((val = r.read()) != -1) {
                this.processCharacter((char)val);
                ++this.lineCharacter;
            }
            if (this.buffer.length() > 0) {
                if (this.state == State.TEXT || this.state == State.LINE_SEPARATOR) {
                    this.flushText();
                } else {
                    ParserError code;
                    Object reason;
                    if (this.state == State.TAG_INSIDE_STRING_LITERAL) {
                        reason = "unterminated string literal";
                        code = ParserError.UNTERMINATED_STRING_LITERAL;
                    } else if (this.state == State.TAG_INSIDE) {
                        reason = "unterminated section";
                        code = ParserError.UNTERMINATED_SECTION;
                    } else {
                        reason = "unexpected state [" + this.state + "]";
                        code = ParserError.GENERAL_ERROR;
                    }
                    throw this.error(code, "unexpected non-text buffer at the end of the template - {reason}: {buffer}").argument("reason", reason).argument("buffer", this.buffer).build();
                }
            }
            for (int i = 0; i < this.paramDeclarationDefaults; ++i) {
                SectionNode.Builder section = this.sectionStack.pop();
                this.sectionStack.peek().currentBlock().addNode(section.build());
                this.scopeStack.pop();
            }
            SectionNode.Builder root = this.sectionStack.peek();
            if (root == null) {
                throw this.error(ParserError.GENERAL_ERROR, "no root section found").build();
            }
            if (!root.helperName.equals(ROOT_HELPER_NAME)) {
                throw this.error(ParserError.UNTERMINATED_SECTION, "unterminated section [{tag}] detected").argument("tag", root.helperName).build();
            }
            TemplateImpl template = new TemplateImpl(this.engine, root.build(), this.templateId, this.generatedId, this.variant);
            Set<TemplateNode> nodesToRemove = Collections.emptySet();
            if (this.hasLineSeparator && this.engine.removeStandaloneLines) {
                nodesToRemove = new HashSet<TemplateNode>();
                List<List<TemplateNode>> lines = this.readLines(template.root);
                for (List<TemplateNode> line : lines) {
                    if (!this.isStandalone(line)) continue;
                    for (TemplateNode node : line) {
                        if (node instanceof SectionNode) continue;
                        nodesToRemove.add(node);
                    }
                }
                if (nodesToRemove.isEmpty()) {
                    nodesToRemove = Collections.emptySet();
                }
            }
            template.root.optimizeNodes(nodesToRemove);
            LOGGER.tracef("Parsing finished in %s ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            return template;
        }
        catch (IOException e) {
            throw new TemplateException(e);
        }
    }

    private void processCharacter(char character) {
        switch (this.state) {
            case TEXT: {
                this.text(character);
                break;
            }
            case ESCAPE: {
                this.escape(character);
                break;
            }
            case TAG_INSIDE: {
                this.tag(character);
                break;
            }
            case TAG_INSIDE_STRING_LITERAL: {
                this.tagStringLiteral(character);
                break;
            }
            case COMMENT: {
                this.comment(character);
                break;
            }
            case CDATA: {
                this.cdata(character);
                break;
            }
            case TAG_CANDIDATE: {
                this.tagCandidate(character);
                break;
            }
            case LINE_SEPARATOR: {
                this.lineSeparator(character);
                break;
            }
            default: {
                throw this.error(ParserError.GENERAL_ERROR, "unknown parsing state: {state}").argument("state", (Object)this.state).build();
            }
        }
    }

    private void escape(char character) {
        if (character != '{' && character != '}') {
            this.buffer.append('\\');
        }
        this.buffer.append(character);
        this.state = State.TEXT;
    }

    private void text(char character) {
        if (character == '{') {
            this.state = State.TAG_CANDIDATE;
        } else if (character == '\\') {
            this.state = State.ESCAPE;
        } else if (this.isLineSeparatorStart(character)) {
            this.flushText();
            this.buffer.append(character);
            this.state = State.LINE_SEPARATOR;
        } else {
            this.buffer.append(character);
        }
    }

    private void lineSeparator(char character) {
        if (character == '\n' && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == '\r') {
            this.buffer.append(character);
            this.flushNextLine();
            this.state = State.TEXT;
        } else {
            this.flushNextLine();
            this.state = State.TEXT;
            this.processCharacter(character);
        }
        this.hasLineSeparator = true;
    }

    private void comment(char character) {
        if (character == '}' && this.buffer.length() > 0 && this.buffer.charAt(this.buffer.length() - 1) == '!') {
            this.state = State.TEXT;
            this.buffer = new StringBuilder();
            if (this.engine.removeStandaloneLines) {
                this.sectionStack.peek().currentBlock().addNode(COMMENT_NODE);
            }
        } else {
            this.buffer.append(character);
        }
    }

    private void cdata(char character) {
        if (character == '}' && this.buffer.length() > 0 && this.isCdataEnd(this.buffer.charAt(this.buffer.length() - 1))) {
            this.state = State.TEXT;
            this.buffer.deleteCharAt(this.buffer.length() - 1);
            this.flushText();
        } else {
            this.buffer.append(character);
        }
    }

    private boolean isCdataEnd(char character) {
        return character == '|';
    }

    private void tag(char character) {
        if (LiteralSupport.isStringLiteralSeparator(character)) {
            this.state = State.TAG_INSIDE_STRING_LITERAL;
            this.buffer.append(character);
        } else if (character == '}') {
            this.flushTag();
        } else {
            this.buffer.append(character);
        }
    }

    private void tagStringLiteral(char character) {
        if (LiteralSupport.isStringLiteralSeparator(character)) {
            this.state = State.TAG_INSIDE;
        }
        this.buffer.append(character);
    }

    private void tagCandidate(char character) {
        if (this.isValidIdentifierStart(character)) {
            this.flushText();
            if (character == '!') {
                this.buffer.append(character);
                this.state = State.COMMENT;
            } else if (character == '|') {
                this.state = State.CDATA;
            } else {
                this.buffer.append(character);
                this.state = State.TAG_INSIDE;
            }
        } else {
            this.buffer.append('{');
            this.state = State.TEXT;
            if ('{' == character) {
                this.buffer.append('{');
            } else {
                this.processCharacter(character);
            }
        }
    }

    private boolean isValidIdentifierStart(char character) {
        return Tag.isCommand(character) || character == '!' || character == '|' || character == '_' || Character.isDigit(character) || Character.isAlphabetic(character);
    }

    static boolean isValidIdentifier(String value) {
        int c;
        int length = value.length();
        for (int offset = 0; offset < length; offset += Character.charCount(c)) {
            c = value.codePointAt(offset);
            if (!Character.isWhitespace(c)) {
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean isLineSeparatorStart(char character) {
        return character == '\r' || character == '\n';
    }

    private void flushText() {
        if (this.buffer.length() > 0 && !this.ignoreContent) {
            SectionBlock.Builder block = this.sectionStack.peek().currentBlock();
            block.addNode(new TextNode(this.buffer.toString(), this.origin(0)));
        }
        this.buffer = new StringBuilder();
    }

    private void flushNextLine() {
        if (this.buffer.length() > 0 && !this.ignoreContent) {
            SectionBlock.Builder block = this.sectionStack.peek().currentBlock();
            block.addNode(new LineSeparatorNode(this.buffer.toString(), this.origin(0)));
        }
        this.buffer = new StringBuilder();
        ++this.line;
        this.lineCharacter = 1;
    }

    private void flushTag() {
        this.state = State.TEXT;
        String content = this.buffer.toString().trim();
        String tag = "{" + content + "}";
        if (content.charAt(0) == Tag.SECTION.command.charValue()) {
            this.sectionStart(content, tag);
        } else if (content.charAt(0) == Tag.SECTION_END.command.charValue()) {
            this.sectionEnd(content, tag);
        } else if (content.charAt(0) == Tag.PARAM.command.charValue()) {
            this.parameterDeclaration(content, tag);
        } else {
            this.sectionStack.peek().currentBlock().addNode(new ExpressionNode(this.createExpression(content), this.engine));
        }
        this.buffer = new StringBuilder();
    }

    private void sectionStart(String content, String tag) {
        Iterator<String> iter;
        boolean isEmptySection = false;
        if (content.charAt(content.length() - 1) == Tag.SECTION_END.command.charValue()) {
            content = content.substring(0, content.length() - 1);
            isEmptySection = true;
        }
        if (!(iter = Parser.splitSectionParams(content, this)).hasNext()) {
            throw this.error(ParserError.NO_SECTION_NAME, "no section name declared for {tag}").argument("tag", tag).build();
        }
        String sectionName = iter.next();
        if ((sectionName = sectionName.substring(1, sectionName.length())).isBlank()) {
            throw this.error(ParserError.NO_SECTION_NAME, "no section name declared for {tag}").argument("tag", tag).build();
        }
        SectionNode.Builder lastSection = this.sectionStack.peek();
        if (lastSection != null && lastSection.factory.getBlockLabels().contains(sectionName) || lastSection.factory.treatUnknownSectionsAsBlocks() && !this.engine.getSectionHelperFactories().containsKey(sectionName)) {
            SectionBlock.Builder block = SectionBlock.builder("" + this.sectionBlockIdx++, this, this).setOrigin(this.origin(tag.length() - 1)).setLabel(sectionName);
            lastSection.addBlock(block);
            this.processParams(tag, sectionName, iter, block);
            Scope currentScope = this.scopeStack.peek();
            Scope newScope = lastSection.factory.initializeBlock(currentScope, block);
            this.scopeStack.addFirst(newScope);
        } else {
            SectionHelperFactory<?> factory = this.engine.getSectionHelperFactory(sectionName);
            if (factory == null) {
                throw this.error(ParserError.NO_SECTION_HELPER_FOUND, "no section helper found for {tag}").argument("tag", tag).build();
            }
            SectionNode.Builder sectionNode = SectionNode.builder(sectionName, this.origin(tag.length() - 1), this, this).setEngine(this.engine).setHelperFactory(factory);
            this.paramsStack.addFirst(factory.getParameters());
            this.processParams(tag, "$main", iter, sectionNode.currentBlock());
            Scope currentScope = this.scopeStack.peek();
            Scope newScope = factory.initializeBlock(currentScope, sectionNode.currentBlock());
            if (isEmptySection) {
                this.paramsStack.pop();
                this.sectionStack.peek().currentBlock().addNode(sectionNode.build());
            } else {
                this.scopeStack.addFirst(newScope);
                this.sectionStack.addFirst(sectionNode);
            }
        }
    }

    private void sectionEnd(String content, String tag) {
        SectionNode.Builder section = this.sectionStack.peek();
        SectionBlock.Builder block = section.currentBlock();
        String name = content.substring(1, content.length());
        if (block != null && !block.getLabel().equals("$main") && !section.helperName.equals(name)) {
            if (!name.isEmpty() && !block.getLabel().equals(name)) {
                throw this.error(ParserError.SECTION_BLOCK_END_DOES_NOT_MATCH_START, "section block end tag [{name}] does not match the start tag [{tagName}]").argument("name", name).argument("tagName", block.getLabel()).build();
            }
            section.endBlock();
        } else {
            if (section.helperName.equals(ROOT_HELPER_NAME)) {
                throw this.error(ParserError.SECTION_START_NOT_FOUND, "section start tag found for {tag}").argument("tag", tag).build();
            }
            if (!name.isEmpty() && !section.helperName.equals(name)) {
                throw this.error(ParserError.SECTION_END_DOES_NOT_MATCH_START, "section end tag [{name}] does not match the start tag [{tag}]").argument("name", name).argument("tag", section.helperName).build();
            }
            section = this.sectionStack.pop();
            this.sectionStack.peek().currentBlock().addNode(section.build());
        }
        this.scopeStack.pop();
    }

    private void parameterDeclaration(String content, String tag) {
        Scope currentScope = this.scopeStack.peek();
        List<String> parts = Expressions.splitParts(content.substring(1).trim(), Expressions.PARAM_DECLARATION_SPLIT_CONFIG);
        String value = null;
        String key = null;
        String defaultValue = null;
        if (parts.size() >= 2 && parts.size() <= 4) {
            value = parts.get(0);
            key = parts.get(1);
            if (parts.size() == 4 && "=".equals(parts.get(2))) {
                defaultValue = parts.get(3);
            } else if (parts.size() == 2) {
                int eqIdx = key.indexOf(61);
                if (eqIdx != -1) {
                    defaultValue = key.substring(eqIdx + 1);
                    key = key.substring(0, eqIdx);
                }
            } else if (parts.size() == 3) {
                String defValPart = parts.get(2);
                int eqIdx = defValPart.indexOf(61);
                if (eqIdx != -1) {
                    defaultValue = defValPart.substring(eqIdx + 1);
                } else {
                    eqIdx = key.indexOf(61);
                    if (eqIdx != -1) {
                        defaultValue = defValPart;
                        key = key.substring(0, eqIdx);
                    }
                }
            }
        }
        if (key == null || value == null || parts.size() > 2 && defaultValue == null) {
            throw this.error(ParserError.INVALID_PARAM_DECLARATION, "invalid parameter declaration {param}").argument("param", "{" + this.buffer.toString() + "}").origin(this.origin(0)).build();
        }
        String typeInfo = Expressions.typeInfoFrom(value);
        currentScope.putBinding(key, typeInfo);
        this.sectionStack.peek().currentBlock().addNode(new ParameterDeclarationNode(typeInfo, key, defaultValue != null ? this.createExpression(defaultValue) : null, this.origin(0)));
        if (defaultValue != null) {
            SectionHelperFactory<?> factory = this.engine.getSectionHelperFactory("let");
            if (factory == null) {
                throw this.error(ParserError.NO_SECTION_HELPER_FOUND, "Parameter declaration with a default value requires a \\{#let} section helper to be present: {tag}").argument("tag", tag).build();
            }
            SectionNode.Builder sectionNode = SectionNode.builder("let", this.origin(0), this, this).setEngine(this.engine).setHelperFactory(factory);
            this.paramsStack.addFirst(factory.getParameters());
            this.processParams(tag, "$main", List.of(key + "?=" + defaultValue).iterator(), sectionNode.currentBlock());
            currentScope = this.scopeStack.peek();
            Scope newScope = factory.initializeBlock(currentScope, sectionNode.currentBlock());
            this.scopeStack.addFirst(newScope);
            this.sectionStack.addFirst(sectionNode);
            ++this.paramDeclarationDefaults;
        }
    }

    @Override
    public TemplateException.Builder error(String message) {
        return Parser.error(ParserError.GENERAL_ERROR, message, null);
    }

    private TemplateException.Builder error(ErrorCode code, String message) {
        return Parser.error(code, message, this.origin(0));
    }

    static TemplateException.Builder error(ErrorCode code, String message, TemplateNode.Origin origin) {
        return TemplateException.builder().code(code).origin(origin).message("Parser error{#if origin.hasNonGeneratedTemplateId??} in{origin}{/if}: " + message);
    }

    @Override
    public TemplateNode.Origin getOrigin() {
        return this.origin(0);
    }

    private void processParams(String tag, String label, Iterator<String> iter, SectionBlock.Builder block) {
        LinkedHashMap<Object, String> params = new LinkedHashMap<Object, String>();
        SectionHelperFactory.ParametersInfo factoryParamsInfo = this.paramsStack.peek();
        List<Parameter> factoryParams = factoryParamsInfo.get(label);
        ArrayList<String> paramValues = new ArrayList<String>();
        while (iter.hasNext()) {
            String val = iter.next().trim();
            if (val.isEmpty()) continue;
            paramValues.add(val);
        }
        int actualSize = paramValues.size();
        if (factoryParamsInfo.isCheckNumberOfParams() && actualSize > factoryParams.size() && LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Too many section params for ").append(tag);
            TemplateNode.Origin origin = this.origin(0);
            origin.appendTo(builder);
            builder.append(String.format("[label=%s, params=%s, factoryParams=%s]", label, paramValues, factoryParams));
            LOGGER.debugf(builder.toString(), new Object[0]);
        }
        Iterator it = paramValues.iterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            int equalsPosition = Parser.getFirstDeterminingEqualsCharPosition(param);
            if (equalsPosition == -1) continue;
            params.put(param.substring(0, equalsPosition), param.substring(equalsPosition + 1, param.length()));
            it.remove();
        }
        Predicate<String> included = params::containsKey;
        if (actualSize < factoryParams.size()) {
            for (String param : paramValues) {
                Parameter parameter = this.findFactoryParameter(param, factoryParams, included, true);
                if (parameter == null) continue;
                params.put(parameter.name, param);
            }
        } else {
            int generatedIdx = 0;
            for (String string : paramValues) {
                Parameter found = this.findFactoryParameter(string, factoryParams, included, false);
                if (found != null) {
                    params.put(found.name, string);
                    continue;
                }
                params.put("" + generatedIdx++, string);
            }
        }
        for (Parameter param : factoryParams) {
            if (!param.hasDefaultValue()) continue;
            params.putIfAbsent(param.name, param.defaultValue);
        }
        ArrayList<String> undeclaredParams = new ArrayList<String>(factoryParams.size());
        for (Parameter parameter : factoryParams) {
            if (parameter.isOptional() || params.containsKey(parameter.name)) continue;
            undeclaredParams.add(parameter.name);
        }
        if (!undeclaredParams.isEmpty()) {
            throw this.error(ParserError.MANDATORY_SECTION_PARAMS_MISSING, "mandatory section parameters not declared for {tag}: {undeclaredParams}").argument("tag", tag).argument("undeclaredParams", undeclaredParams).build();
        }
        for (Map.Entry entry : params.entrySet()) {
            block.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private Parameter findFactoryParameter(String paramValue, List<Parameter> factoryParams, Predicate<String> included, boolean noDefaultValueTakesPrecedence) {
        if (noDefaultValueTakesPrecedence) {
            for (Parameter param : factoryParams) {
                if (!param.accepts(paramValue) || param.hasDefaultValue() || included.test(param.name)) continue;
                return param;
            }
        }
        for (Parameter param : factoryParams) {
            if (!param.accepts(paramValue) || included.test(param.name)) continue;
            return param;
        }
        return null;
    }

    static int getFirstDeterminingEqualsCharPosition(String part) {
        if (!part.isEmpty() && part.charAt(0) == '(') {
            return -1;
        }
        boolean stringLiteral = false;
        for (int i = 0; i < part.length(); ++i) {
            if (LiteralSupport.isStringLiteralSeparator(part.charAt(i))) {
                if (i == 0) {
                    return -1;
                }
                stringLiteral = !stringLiteral;
                continue;
            }
            if (stringLiteral || part.charAt(i) != '=' || i == 0 || i >= part.length() - 1) continue;
            return i;
        }
        return -1;
    }

    static <B extends ErrorInitializer & WithOrigin> Iterator<String> splitSectionParams(String content, B block) {
        boolean stringLiteral = false;
        int composite = 0;
        int brackets = 0;
        boolean space = false;
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == ' ') {
                if (space) continue;
                if (!stringLiteral && composite == 0 && brackets == 0) {
                    if (buffer.length() > 0) {
                        parts.add(buffer.toString());
                        buffer = new StringBuilder();
                    }
                    space = true;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (composite == 0 && LiteralSupport.isStringLiteralSeparator(c)) {
                stringLiteral = !stringLiteral;
            } else if (!stringLiteral && Parser.isCompositeStart(c) && (i == 0 || space || composite > 0 || buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '!')) {
                composite = (short)(composite + 1);
            } else if (!stringLiteral && Parser.isCompositeEnd(c) && composite > 0) {
                composite = (short)(composite - 1);
            } else if (!stringLiteral && Parser.isLeftBracket(c)) {
                brackets = (byte)(brackets + 1);
            } else if (!stringLiteral && Parser.isRightBracket(c) && brackets > 0) {
                brackets = (byte)(brackets - 1);
            }
            space = false;
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            if (stringLiteral || composite > 0) {
                throw block.error("unterminated string literal or composite parameter detected for [{content}]").argument("content", content).code(ParserError.UNTERMINATED_STRING_LITERAL_OR_COMPOSITE_PARAMETER).origin(((WithOrigin)block).getOrigin()).build();
            }
            parts.add(buffer.toString());
        }
        return parts.iterator();
    }

    static boolean isCompositeStart(char character) {
        return character == '(';
    }

    static boolean isCompositeEnd(char character) {
        return character == ')';
    }

    static ExpressionImpl parseExpression(Supplier<Integer> idGenerator, String value, Scope scope, TemplateNode.Origin origin) {
        List<String> strParts;
        int bracketIdx;
        int spaceIdx;
        if (value == null || value.isEmpty()) {
            return ExpressionImpl.EMPTY;
        }
        String namespace = null;
        int namespaceIdx = value.indexOf(58);
        if (!(namespaceIdx == -1 || (spaceIdx = value.indexOf(32)) != -1 && namespaceIdx >= spaceIdx || (bracketIdx = value.indexOf(40)) != -1 && namespaceIdx >= bracketIdx || LiteralSupport.isStringLiteralSeparator(value.charAt(0)))) {
            strParts = Expressions.splitParts(value.substring(namespaceIdx + 1, value.length()));
            namespace = value.substring(0, namespaceIdx);
        } else {
            Object literalValue = LiteralSupport.getLiteralValue(value);
            if (!Results.isNotFound(literalValue)) {
                return ExpressionImpl.literal(idGenerator.get(), value, literalValue, origin);
            }
            strParts = Expressions.splitParts(value);
        }
        if (strParts.isEmpty()) {
            throw Parser.error(ParserError.EMPTY_EXPRESSION, "empty expression found \\{{value}\\}", origin).argument("value", value).build();
        }
        int lastIdx = strParts.size() - 1;
        String last = strParts.get(lastIdx);
        if (last.endsWith("??")) {
            strParts = ImmutableList.builder().addAll(strParts.subList(0, lastIdx)).add(last.substring(0, last.length() - 2)).add("or(null)").build();
        }
        ArrayList<Expression.Part> parts = new ArrayList<Expression.Part>(strParts.size());
        Expression.Part first = null;
        Iterator<String> strPartsIterator = strParts.iterator();
        while (strPartsIterator.hasNext()) {
            Expression.Part part = Parser.createPart(idGenerator, namespace, first, strPartsIterator, scope, origin, value);
            if (!Parser.isValidIdentifier(part.getName())) {
                throw Parser.error(ParserError.INVALID_IDENTIFIER, "invalid identifier found [{value}]", origin).argument("value", value).build();
            }
            if (first == null) {
                first = part;
            }
            parts.add(part);
        }
        return new ExpressionImpl(idGenerator.get(), namespace, ImmutableList.copyOf(parts), Results.NotFound.EMPTY, origin);
    }

    private static Expression.Part createPart(Supplier<Integer> idGenerator, String namespace, Expression.Part first, Iterator<String> strPartsIterator, Scope scope, TemplateNode.Origin origin, String exprValue) {
        String value = strPartsIterator.next();
        if (Expressions.isVirtualMethod(value)) {
            String name = Expressions.parseVirtualMethodName(value);
            ArrayList<String> strParams = new ArrayList<String>(Expressions.parseVirtualMethodParams(value, origin, exprValue));
            ArrayList<Expression> params = new ArrayList<Expression>(strParams.size());
            Scope paramScope = new Scope(scope);
            for (String strParam : strParams) {
                params.add(Parser.parseExpression(idGenerator, strParam.trim(), paramScope, origin));
            }
            String lastPartHint = strPartsIterator.hasNext() ? null : scope.getLastPartHint();
            return new ExpressionImpl.VirtualMethodPartImpl(name, params, lastPartHint);
        }
        if (Expressions.isBracketNotation(value)) {
            Object literal = LiteralSupport.getLiteralValue(value = Expressions.parseBracketContent(value, origin, exprValue));
            if (literal != null && !Results.isNotFound(literal)) {
                value = literal.toString();
            } else {
                throw TemplateException.builder().message((literal == null ? "Null" : "Non-literal") + " value used in bracket notation [{value}] {origin}").argument("value", value).build();
            }
        }
        Object typeInfo = null;
        if (namespace != null) {
            typeInfo = first != null ? value : namespace + ":" + value;
        } else if (first == null) {
            typeInfo = scope.getBinding(value);
        } else if (first.getTypeInfo() != null) {
            typeInfo = value;
        }
        if (typeInfo != null && !strPartsIterator.hasNext() && scope.getLastPartHint() != null) {
            typeInfo = (String)typeInfo + scope.getLastPartHint();
        }
        return new ExpressionImpl.PartImpl(value, (String)typeInfo);
    }

    static boolean isLeftBracket(char character) {
        return character == '(';
    }

    static boolean isRightBracket(char character) {
        return character == ')';
    }

    ExpressionImpl createSectionBlockExpression(SectionHelperFactory.BlockInfo block, String value) {
        return Parser.parseExpression(this.expressionIdGenerator::incrementAndGet, value, this.scopeStack.peek(), block.getOrigin());
    }

    ExpressionImpl createExpression(String value) {
        return Parser.parseExpression(this.expressionIdGenerator::incrementAndGet, value, this.scopeStack.peek(), this.origin(value.length() + 1));
    }

    TemplateNode.Origin origin(int lineCharacterOffset) {
        return new OriginImpl(this.line, this.lineCharacter - lineCharacterOffset, this.lineCharacter, this.templateId, this.generatedId, this.variant);
    }

    private List<List<TemplateNode>> readLines(SectionNode rootNode) {
        ArrayList<List<TemplateNode>> lines = new ArrayList<List<TemplateNode>>();
        lines.add(this.readLines(lines, null, rootNode));
        return lines;
    }

    private List<TemplateNode> readLines(List<List<TemplateNode>> lines, List<TemplateNode> currentLine, SectionNode sectionNode) {
        boolean isRoot;
        if (currentLine == null) {
            currentLine = new ArrayList<TemplateNode>();
        }
        if (!(isRoot = ROOT_HELPER_NAME.equals(sectionNode.name))) {
            currentLine.add(sectionNode);
        }
        for (SectionBlock block : sectionNode.blocks) {
            if (!isRoot) {
                currentLine.add(BLOCK_NODE);
            }
            for (TemplateNode node : block.nodes) {
                if (node instanceof SectionNode) {
                    currentLine = this.readLines(lines, currentLine, (SectionNode)node);
                    continue;
                }
                if (node instanceof LineSeparatorNode) {
                    currentLine.add(node);
                    lines.add(currentLine);
                    currentLine = new ArrayList<TemplateNode>();
                    continue;
                }
                currentLine.add(node);
            }
            if (isRoot) continue;
            currentLine.add(BLOCK_NODE);
        }
        if (!ROOT_HELPER_NAME.equals(sectionNode.name)) {
            currentLine.add(sectionNode);
        }
        return currentLine;
    }

    private boolean isStandalone(List<TemplateNode> line) {
        boolean maybeStandalone = false;
        for (TemplateNode node : line) {
            if (node instanceof ExpressionNode) {
                return false;
            }
            if (node instanceof SectionNode || node instanceof ParameterDeclarationNode || node == BLOCK_NODE || node == COMMENT_NODE) {
                maybeStandalone = true;
                continue;
            }
            if (!(node instanceof TextNode) || this.isBlank(((TextNode)node).getValue())) continue;
            return false;
        }
        return maybeStandalone;
    }

    private boolean isBlank(CharSequence val) {
        if (val == null) {
            return true;
        }
        int length = val.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(val.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String toString(Reader in) throws IOException {
        if (in instanceof StringReader) {
            return ((StringReader)in).str;
        }
        StringBuilder out = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        while (in.read(buffer) != -1) {
            buffer.flip();
            out.append(buffer);
            buffer.clear();
        }
        return out.toString();
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    public void addParameter(String name, String type) {
        Scope currentScope = this.scopeStack.peek();
        currentScope.putBinding(name, Expressions.typeInfoFrom(type));
    }

    @Override
    public void addContentFilter(Function<String, String> filter) {
        this.contentFilters.add(filter);
    }

    static class CommentNode
    implements TemplateNode {
        CommentNode() {
        }

        @Override
        public CompletionStage<ResultNode> resolve(ResolutionContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TemplateNode.Origin getOrigin() {
            throw new UnsupportedOperationException();
        }
    }

    private static class BlockNode
    implements TemplateNode {
        private BlockNode() {
        }

        @Override
        public CompletionStage<ResultNode> resolve(ResolutionContext context) {
            throw new IllegalStateException();
        }

        @Override
        public TemplateNode.Origin getOrigin() {
            throw new IllegalStateException();
        }
    }

    static class OriginImpl
    implements TemplateNode.Origin {
        private final int line;
        private final int lineCharacterStart;
        private final int lineCharacterEnd;
        private final String templateId;
        private final String templateGeneratedId;
        private final Optional<Variant> variant;

        OriginImpl(int line, int lineCharacterStart, int lineCharacterEnd, String templateId, String templateGeneratedId, Optional<Variant> variant) {
            this.line = line;
            this.lineCharacterStart = lineCharacterStart;
            this.lineCharacterEnd = lineCharacterEnd;
            this.templateId = templateId;
            this.templateGeneratedId = templateGeneratedId;
            this.variant = variant;
        }

        @Override
        public int getLine() {
            return this.line;
        }

        @Override
        public int getLineCharacterStart() {
            return this.lineCharacterStart;
        }

        @Override
        public int getLineCharacterEnd() {
            return this.lineCharacterEnd;
        }

        @Override
        public String getTemplateId() {
            return this.templateId;
        }

        @Override
        public String getTemplateGeneratedId() {
            return this.templateGeneratedId;
        }

        @Override
        public Optional<Variant> getVariant() {
            return this.variant;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.templateGeneratedId, this.templateId, this.variant);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OriginImpl other = (OriginImpl)obj;
            return this.line == other.line && Objects.equals(this.templateGeneratedId, other.templateGeneratedId) && Objects.equals(this.templateId, other.templateId) && Objects.equals(this.variant, other.variant);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.appendTo(builder);
            return builder.toString();
        }
    }

    static class StringReader
    extends java.io.StringReader {
        final String str;

        public StringReader(String s) {
            super(s);
            this.str = s;
        }
    }

    static enum State {
        TEXT,
        TAG_INSIDE,
        TAG_INSIDE_STRING_LITERAL,
        TAG_CANDIDATE,
        COMMENT,
        ESCAPE,
        CDATA,
        LINE_SEPARATOR;

    }

    static enum Tag {
        EXPRESSION(null),
        SECTION(Character.valueOf('#')),
        SECTION_END(Character.valueOf('/')),
        PARAM(Character.valueOf('@'));

        final Character command;

        private Tag(Character command) {
            this.command = command;
        }

        static boolean isCommand(char command) {
            for (Tag tag : Tag.values()) {
                if (tag.command == null || tag.command.charValue() != command) continue;
                return true;
            }
            return false;
        }
    }

    static class RootSectionHelperFactory
    implements SectionHelperFactory<SectionHelper> {
        RootSectionHelperFactory() {
        }

        @Override
        public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
            return new SectionHelper(){

                @Override
                public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
                    return context.execute();
                }
            };
        }
    }
}

