/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.ClientProxies;
import org.jboss.resteasy.reactive.client.spi.ClientContextResolver;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

public class ClientBuilderImpl
extends ClientBuilder {
    private ClientProxies clientProxies;
    private ConfigurationImpl configuration;
    private SSLContext sslContext;
    private KeyStore trustStore;
    private KeyStore keyStore;
    private char[] keystorePassword;
    private HostnameVerifier hostnameVerifier;
    private static final ClientContextResolver CLIENT_CONTEXT_RESOLVER = ClientContextResolver.getInstance();

    public ClientBuilder withConfig(Configuration config) {
        this.configuration = new ConfigurationImpl(config);
        return this;
    }

    public ClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.keyStore = null;
        this.trustStore = null;
        return this;
    }

    public ClientBuilder keyStore(KeyStore keyStore, char[] password) {
        return this;
    }

    public ClientBuilder trustStore(KeyStore trustStore) {
        return this;
    }

    public ClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
        return this;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        return this;
    }

    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return this;
    }

    public ClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        return this;
    }

    public ClientBuilder readTimeout(long timeout, TimeUnit unit) {
        return this;
    }

    public Client build() {
        return new ClientImpl(this.configuration, CLIENT_CONTEXT_RESOLVER.resolve(Thread.currentThread().getContextClassLoader()), this.hostnameVerifier, this.sslContext);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ClientBuilder property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass) {
        this.configuration.register(componentClass);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, int priority) {
        this.configuration.register(componentClass, priority);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.configuration.register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.configuration.register(componentClass, contracts);
        return this;
    }

    public ClientBuilderImpl register(Object component) {
        this.configuration.register(component);
        return this;
    }

    public ClientBuilderImpl register(Object component, int priority) {
        this.configuration.register(component, priority);
        return this;
    }

    public ClientBuilderImpl register(Object component, Class<?> ... contracts) {
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public ClientBuilderImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.configuration.register(component, contracts);
        return this;
    }
}

