/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.spi.VerticleFactory;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;
import org.jboss.resteasy.reactive.client.impl.HandlerChain;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.spi.ClientContext;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.MultiQueryParamMode;
import org.jboss.resteasy.reactive.common.jaxrs.UriBuilderImpl;

public class ClientImpl
implements Client {
    private static final Logger log = Logger.getLogger(ClientImpl.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_CONNECTION_POOL_SIZE = 20;
    final ClientContext clientContext;
    final boolean closeVertx;
    final HttpClient httpClient;
    final ConfigurationImpl configuration;
    final HostnameVerifier hostnameVerifier;
    final SSLContext sslContext;
    private boolean isClosed;
    final HandlerChain handlerChain;
    final Vertx vertx;
    private final MultiQueryParamMode multiQueryParamMode;

    public ClientImpl(HttpClientOptions options, ConfigurationImpl configuration, ClientContext clientContext, HostnameVerifier hostnameVerifier, SSLContext sslContext, boolean followRedirects, MultiQueryParamMode multiQueryParamMode, LoggingScope loggingScope, ClientLogger clientLogger) {
        Object connectionPoolSize;
        Object connectionTTL;
        this.configuration = configuration = configuration != null ? configuration : new ConfigurationImpl(RuntimeType.CLIENT);
        this.clientContext = clientContext;
        this.hostnameVerifier = hostnameVerifier;
        this.sslContext = sslContext;
        this.multiQueryParamMode = multiQueryParamMode;
        Supplier<Vertx> vertx = clientContext.getVertx();
        if (vertx != null) {
            this.vertx = vertx.get();
            this.closeVertx = false;
        } else {
            this.vertx = new LazyVertx(new Supplier<Vertx>(){

                @Override
                public Vertx get() {
                    return Vertx.vertx();
                }
            });
            this.closeVertx = true;
        }
        Object connectTimeoutMs = configuration.getProperty("io.quarkus.rest.client.connect-timeout");
        if (connectTimeoutMs == null) {
            options.setConnectTimeout(15000);
        } else {
            options.setConnectTimeout(((Integer)connectTimeoutMs).intValue());
        }
        Object maxRedirects = configuration.getProperty("io.quarkus.rest.client.max-redirects");
        if (maxRedirects != null) {
            options.setMaxRedirects(((Integer)maxRedirects).intValue());
        }
        if ((connectionTTL = configuration.getProperty("io.quarkus.rest.client.connection-ttl")) != null) {
            options.setKeepAliveTimeout(((Integer)connectionTTL).intValue());
        }
        if ((connectionPoolSize = configuration.getProperty("io.quarkus.rest.client.connection-pool-size")) == null) {
            connectionPoolSize = 20;
        } else {
            log.debugf("Setting connectionPoolSize to %d s", connectionPoolSize);
        }
        options.setMaxPoolSize(((Integer)connectionPoolSize).intValue());
        if (loggingScope == LoggingScope.ALL) {
            options.setLogActivity(true);
        }
        this.httpClient = this.vertx.createHttpClient(options);
        if (loggingScope != LoggingScope.NONE) {
            Function defaultRedirectHandler = this.httpClient.redirectHandler();
            this.httpClient.redirectHandler(response -> {
                clientLogger.logResponse((HttpClientResponse)response, true);
                return (Future)defaultRedirectHandler.apply(response);
            });
        }
        this.handlerChain = new HandlerChain(followRedirects, loggingScope, clientLogger);
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.httpClient.close();
        if (this.closeVertx) {
            this.vertx.close();
        }
    }

    void abortIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    public WebTarget target(String uri) {
        Objects.requireNonNull(uri);
        return this.target(UriBuilder.fromUri((String)uri));
    }

    public WebTarget target(URI uri) {
        Objects.requireNonNull(uri);
        return this.target(UriBuilder.fromUri((URI)uri));
    }

    public WebTarget target(UriBuilder uriBuilder) {
        this.abortIfClosed();
        Objects.requireNonNull(uriBuilder);
        if (uriBuilder instanceof UriBuilderImpl && this.multiQueryParamMode != null) {
            ((UriBuilderImpl)uriBuilder).multiQueryParamMode(this.multiQueryParamMode);
        }
        return new WebTargetImpl(this, this.httpClient, uriBuilder, new ConfigurationImpl((Configuration)this.configuration), this.handlerChain, null);
    }

    public WebTarget target(Link link) {
        Objects.requireNonNull(link);
        return this.target(UriBuilder.fromLink((Link)link));
    }

    public Invocation.Builder invocation(Link link) {
        this.abortIfClosed();
        Objects.requireNonNull(link);
        Invocation.Builder request = this.target(link).request();
        if (link.getType() != null) {
            request.accept(new String[]{link.getType()});
        }
        return request;
    }

    public SSLContext getSslContext() {
        this.abortIfClosed();
        return this.sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        this.abortIfClosed();
        return this.hostnameVerifier;
    }

    public ConfigurationImpl getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    public Client property(String name, Object value) {
        this.abortIfClosed();
        this.configuration.property(name, value);
        return this;
    }

    public Client register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register(componentClass);
        return this;
    }

    public Client register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register(componentClass, priority);
        return this;
    }

    public Client register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, (Class[])contracts);
        return this;
    }

    public Client register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, contracts);
        return this;
    }

    public Client register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    public Client register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    public Client register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public Client register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, contracts);
        return this;
    }

    Vertx getVertx() {
        return this.vertx;
    }

    private static class LazyVertx
    implements Vertx {
        private final Supplier<Vertx> supplier;
        private volatile Vertx supplied = null;

        LazyVertx(Supplier<Vertx> supplier) {
            this.supplier = supplier;
        }

        private Vertx getDelegate() {
            if (this.supplied == null) {
                this.supplied = this.supplier.get();
            }
            return this.supplied;
        }

        public Context getOrCreateContext() {
            return this.getDelegate().getOrCreateContext();
        }

        public NetServer createNetServer(NetServerOptions netServerOptions) {
            return this.getDelegate().createNetServer(netServerOptions);
        }

        public NetServer createNetServer() {
            return this.getDelegate().createNetServer();
        }

        public NetClient createNetClient(NetClientOptions netClientOptions) {
            return this.getDelegate().createNetClient(netClientOptions);
        }

        public NetClient createNetClient() {
            return this.getDelegate().createNetClient();
        }

        public HttpServer createHttpServer(HttpServerOptions httpServerOptions) {
            return this.getDelegate().createHttpServer(httpServerOptions);
        }

        public HttpServer createHttpServer() {
            return this.getDelegate().createHttpServer();
        }

        public HttpClient createHttpClient(final HttpClientOptions httpClientOptions) {
            return new LazyHttpClient(new Supplier<HttpClient>(){

                @Override
                public HttpClient get() {
                    return this.getDelegate().createHttpClient(httpClientOptions);
                }
            });
        }

        public HttpClient createHttpClient() {
            return new LazyHttpClient(new Supplier<HttpClient>(){

                @Override
                public HttpClient get() {
                    return this.getDelegate().createHttpClient();
                }
            });
        }

        public DatagramSocket createDatagramSocket(DatagramSocketOptions datagramSocketOptions) {
            return this.getDelegate().createDatagramSocket(datagramSocketOptions);
        }

        public DatagramSocket createDatagramSocket() {
            return this.getDelegate().createDatagramSocket();
        }

        public FileSystem fileSystem() {
            return this.getDelegate().fileSystem();
        }

        public EventBus eventBus() {
            return this.getDelegate().eventBus();
        }

        public DnsClient createDnsClient(int i, String s) {
            return this.getDelegate().createDnsClient(i, s);
        }

        public DnsClient createDnsClient() {
            return this.getDelegate().createDnsClient();
        }

        public DnsClient createDnsClient(DnsClientOptions dnsClientOptions) {
            return this.getDelegate().createDnsClient(dnsClientOptions);
        }

        public SharedData sharedData() {
            return this.getDelegate().sharedData();
        }

        public long setTimer(long l, Handler<Long> handler) {
            return this.getDelegate().setTimer(l, handler);
        }

        public TimeoutStream timerStream(long l) {
            return this.getDelegate().timerStream(l);
        }

        public long setPeriodic(long l, Handler<Long> handler) {
            return this.getDelegate().setPeriodic(l, handler);
        }

        public TimeoutStream periodicStream(long l) {
            return this.getDelegate().periodicStream(l);
        }

        public boolean cancelTimer(long l) {
            return this.getDelegate().cancelTimer(l);
        }

        public void runOnContext(Handler<Void> handler) {
            this.getDelegate().runOnContext(handler);
        }

        public Future<Void> close() {
            if (this.supplied != null) {
                return this.getDelegate().close();
            }
            return Future.succeededFuture();
        }

        public void close(Handler<AsyncResult<Void>> handler) {
            if (this.supplied != null) {
                this.getDelegate().close(handler);
            }
        }

        public Future<String> deployVerticle(Verticle verticle) {
            return this.getDelegate().deployVerticle(verticle);
        }

        public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(verticle, handler);
        }

        public static Vertx vertx() {
            return Vertx.vertx();
        }

        public static Vertx vertx(VertxOptions options) {
            return Vertx.vertx((VertxOptions)options);
        }

        public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
            Vertx.clusteredVertx((VertxOptions)options, resultHandler);
        }

        public static Future<Vertx> clusteredVertx(VertxOptions options) {
            return Vertx.clusteredVertx((VertxOptions)options);
        }

        public static Context currentContext() {
            return Vertx.currentContext();
        }

        public Future<String> deployVerticle(Verticle verticle, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(verticle, options);
        }

        public Future<String> deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(verticleClass, options);
        }

        public Future<String> deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(verticleSupplier, options);
        }

        public void deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(verticle, options, completionHandler);
        }

        public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(verticleClass, options, completionHandler);
        }

        public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(verticleSupplier, options, completionHandler);
        }

        public Future<String> deployVerticle(String name) {
            return this.getDelegate().deployVerticle(name);
        }

        public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(name, completionHandler);
        }

        public Future<String> deployVerticle(String name, DeploymentOptions options) {
            return this.getDelegate().deployVerticle(name, options);
        }

        public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
            this.getDelegate().deployVerticle(name, options, completionHandler);
        }

        public Future<Void> undeploy(String deploymentID) {
            return this.getDelegate().undeploy(deploymentID);
        }

        public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
            this.getDelegate().undeploy(deploymentID, completionHandler);
        }

        public Set<String> deploymentIDs() {
            return this.getDelegate().deploymentIDs();
        }

        public void registerVerticleFactory(VerticleFactory factory) {
            this.getDelegate().registerVerticleFactory(factory);
        }

        public void unregisterVerticleFactory(VerticleFactory factory) {
            this.getDelegate().unregisterVerticleFactory(factory);
        }

        public Set<VerticleFactory> verticleFactories() {
            return this.getDelegate().verticleFactories();
        }

        public boolean isClustered() {
            return this.getDelegate().isClustered();
        }

        public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
            this.getDelegate().executeBlocking(blockingCodeHandler, ordered, asyncResultHandler);
        }

        public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
            this.getDelegate().executeBlocking(blockingCodeHandler, asyncResultHandler);
        }

        public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
            return this.getDelegate().executeBlocking(blockingCodeHandler, ordered);
        }

        public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
            return this.getDelegate().executeBlocking(blockingCodeHandler);
        }

        public EventLoopGroup nettyEventLoopGroup() {
            return this.getDelegate().nettyEventLoopGroup();
        }

        public WorkerExecutor createSharedWorkerExecutor(String name) {
            return this.getDelegate().createSharedWorkerExecutor(name);
        }

        public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) {
            return this.getDelegate().createSharedWorkerExecutor(name, poolSize);
        }

        public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
            return this.getDelegate().createSharedWorkerExecutor(name, poolSize, maxExecuteTime);
        }

        public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
            return this.getDelegate().createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit);
        }

        public boolean isNativeTransportEnabled() {
            return this.getDelegate().isNativeTransportEnabled();
        }

        public Vertx exceptionHandler(Handler<Throwable> handler) {
            return this.getDelegate().exceptionHandler(handler);
        }

        public Handler<Throwable> exceptionHandler() {
            return this.getDelegate().exceptionHandler();
        }

        public boolean isMetricsEnabled() {
            return this.getDelegate().isMetricsEnabled();
        }

        private static class LazyHttpClient
        implements HttpClient {
            private final Supplier<HttpClient> supplier;
            private volatile HttpClient supplied = null;

            LazyHttpClient(Supplier<HttpClient> supplier) {
                this.supplier = supplier;
            }

            private HttpClient getDelegate() {
                if (this.supplied == null) {
                    this.supplied = this.supplier.get();
                }
                return this.supplied;
            }

            public void request(RequestOptions options, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(options, handler);
            }

            public Future<HttpClientRequest> request(RequestOptions options) {
                return this.getDelegate().request(options);
            }

            public void request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(method, port, host, requestURI, handler);
            }

            public Future<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
                return this.getDelegate().request(method, port, host, requestURI);
            }

            public void request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(method, host, requestURI, handler);
            }

            public Future<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
                return this.getDelegate().request(method, host, requestURI);
            }

            public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
                this.getDelegate().request(method, requestURI, handler);
            }

            public Future<HttpClientRequest> request(HttpMethod method, String requestURI) {
                return this.getDelegate().request(method, requestURI);
            }

            public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(port, host, requestURI, handler);
            }

            public Future<WebSocket> webSocket(int port, String host, String requestURI) {
                return this.getDelegate().webSocket(port, host, requestURI);
            }

            public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(host, requestURI, handler);
            }

            public Future<WebSocket> webSocket(String host, String requestURI) {
                return this.getDelegate().webSocket(host, requestURI);
            }

            public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(requestURI, handler);
            }

            public Future<WebSocket> webSocket(String requestURI) {
                return this.getDelegate().webSocket(requestURI);
            }

            public void webSocket(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(options, handler);
            }

            public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
                return this.getDelegate().webSocket(options);
            }

            public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocketAbs(url, headers, version, subProtocols, handler);
            }

            public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
                return this.getDelegate().webSocketAbs(url, headers, version, subProtocols);
            }

            public HttpClient connectionHandler(Handler<HttpConnection> handler) {
                return this.getDelegate().connectionHandler(handler);
            }

            public HttpClient redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
                return this.getDelegate().redirectHandler(handler);
            }

            public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
                return this.getDelegate().redirectHandler();
            }

            public void close(Handler<AsyncResult<Void>> handler) {
                if (this.supplied != null) {
                    this.getDelegate().close(handler);
                }
                if (handler != null) {
                    handler.handle((Object)Future.succeededFuture());
                }
            }

            public Future<Void> close() {
                if (this.supplied != null) {
                    return this.getDelegate().close();
                }
                return Future.succeededFuture();
            }

            public boolean isMetricsEnabled() {
                return this.getDelegate().isMetricsEnabled();
            }
        }
    }
}

